package com.meizu.cloud.pushsdk.common.util;

import java.util.HashMap;

/**
 * Created by zbin on 2016/1/14 0014.
 */
public class SystemProperties {
    private static HashMap<String, Reflector.Result> sPropertyCache = new HashMap<>();

    public static <T> Reflector.Result<T> get(String key) {
        if(sPropertyCache.containsKey(key)) {
            return sPropertyCache.get(key);
        }

        Reflector.Result<T> result = Reflector.forName("android.os.SystemProperties")
                .setMethodName("get")
                .setArgs(new Object[] {key})
                .invoke();
        if(result.ok) {
            sPropertyCache.put(key, result);
        }
        return result;
    }
}
