package com.meizu.cloud.pushsdk.handler;

import android.content.Context;

import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.message.SubAliasStatus;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;
import com.meizu.cloud.pushsdk.platform.message.UnRegisterStatus;

/**
 * Created by liaojinlong on 16-1-8.
 */
public interface AppLogicListener {
    /**
     * 用户注册
     * */
    public void onRegister(Context context,String pushId);

    /**
     * 推送消息
     * */
    public void onMessage(Context context,String message);

    /**
     * 反注册
     * */
    public void onUnRegister(Context context,boolean success);

    /**
     * 创建通知栏
     * */
    public void onUpdateNotificationBuilder(PushNotificationBuilder pushNotificationBuilder);

    /**
     * push开关状态回调
     * */
    public void onPushStatus(Context context,PushSwitchStatus pushSwitchStatus);

    /**
     * 注册状态回调
     * */
    public void onRegisterStatus(Context context,RegisterStatus registerStatus);

    /**
     * 反注册回调
     * */
    public void onUnRegisterStatus(Context context,UnRegisterStatus unRegisterStatus);

    /**
     * 标签订阅状态回调
     * */
    public void onSubTagsStatus(Context context,SubTagsStatus subTagsStatus);

    /**
     * 别名订阅状态回调
     * */
    public void onSubAliasStatus(Context context,SubAliasStatus subAliasStatus);


    /**
     * 接收通知点击的函数
     * @param context
     * @param title
     *           通知标题
     * @param content
     *           通知内容
     * @param selfDefineContentString
     *           自定义内容，为空或者json字符串
     * */
    public void onNotificationClicked(Context context, String title, String content, String selfDefineContentString);

    /**
     * 接收通知到达的函数
     * @param context
     * @param title
     *           通知标题
     * @param content
     *           通知内容
     * @param selfDefineContentString
     *           自定义内容，为空或者json字符串
     * */
    public void onNotificationArrived(Context context, String title, String content, String selfDefineContentString);

    /**
     * 接收通知删除的函数
     * @param context
     * @param title
     *           通知标题
     * @param content
     *           通知内容
     * @param selfDefineContentString
     *           自定义内容，为空或者json字符串
     * */
    public void onNotificationDeleted(Context context, String title, String content, String selfDefineContentString);

    /**
     * Flyme6.0 上接收推送服务发送的通知栏消息
     * @param context
     * @param message 通知栏消息，多个通知栏消息以json数组的方式呈现
     * */
    public void onNotifyMessageArrived(Context context,String message);
 }
