package com.meizu.cloud.pushsdk.handler.impl;

import android.content.Context;
import android.content.Intent;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.constants.PushConstants;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.notification.MPushMessage;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.util.UxIPUtils;

/**
 * process PushService V2 MPushMessage
 */
public class MessageV2Handler extends MessageV3Handler {

    public MessageV2Handler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i(TAG, "start MessageV2Handler match");
        if(!canReceiveMessage(0,getPushServiceDefaultPackageName(intent))){
            return false;
        }
        return PushConstants.MZ_PUSH_ON_MESSAGE_ACTION.equals(intent.getAction())
                && PushConstants.MZ_PUSH_MESSAGE_METHOD_ACTION_NOTIFICATION_SHOW.equals(getIntentMethod(intent));
    }

    @Override
    public int getProcessorType() {
        return MESSAGE_TYPE_PUSH_SERVICE_V2;
    }

    @Override
    protected MessageV3 getMessage(Intent intent) {
        MPushMessage mPushMessage = (MPushMessage) intent.getSerializableExtra(PushConstants.MZ_PUSH_PRIVATE_MESSAGE);
        return MessageV3.parse(getPushServiceDefaultPackageName(intent),
                getDeviceId(intent),
                mPushMessage.getTaskId(),
                mPushMessage);
    }

    @Override
    protected void unsafeSend(MessageV3 message, PushNotification pushNotification) {
        if(pushNotification != null){
            pushNotification.show(message);
            appLogicListener().onNotificationArrived(context(),message.getTitle(),message.getContent(), selfDefineContentString(message.getWebUrl(),message.getParamsMap()));
        }
    }


    @Override
    protected void onBeforeEvent(MessageV3 message) {
        UxIPUtils.onReceivePushMessageEvent(context(), message.getUploadDataPackageName(), message.getDeviceId(), message.getTaskId(),message.getSeqId(),message.getPushTimestamp());
    }

    @Override
    protected void onAfterEvent(MessageV3 message) {
        UxIPUtils.onShowPushMessageEvent(context(), message.getUploadDataPackageName(), message.getDeviceId(), message.getTaskId(),message.getSeqId(),message.getPushTimestamp());
    }
}
