package com.meizu.cloud.pushsdk.handler.impl.platform;

import android.content.Context;
import android.content.Intent;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.constants.PushConstants;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;

/**
 * Created by liaojinlong on 16-4-26.
 */
public class PushSwitchStatusHandler extends AbstractMessageHandler<PushSwitchStatus> {

    public PushSwitchStatusHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    protected PushSwitchStatus getMessage(Intent intent) {
        PushSwitchStatus pushSwitchStatus = (PushSwitchStatus) intent.getSerializableExtra(PushConstants.EXTRA_APP_PUSH_SWITCH_STATUS);
        /*if("200".equals(pushSwitchStatus.getCode())){
            PushPreferencesUtils.setNotificationMessageSwitchStatus(context(),getPushServiceDefaultPackageName(intent),pushSwitchStatus.isSwitchNotificationMessage());
            PushPreferencesUtils.setThroughMessageSwitchStatus(context(),getPushServiceDefaultPackageName(intent),pushSwitchStatus.isSwitchThroughMessage());
        }*/
        return pushSwitchStatus;
    }

    @Override
    protected void unsafeSend(PushSwitchStatus message, PushNotification pushNotification) {
        if(appLogicListener() != null && message != null){
            appLogicListener().onPushStatus(context(),message);
        }
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i(TAG, "start PushSwitchStatusHandler match");
        return PushConstants.MZ_PUSH_ON_MESSAGE_ACTION.equals(intent.getAction())
                && PushConstants.MZ_PUSH_MESSAGE_METHOD_ACTION_PUSH_STATUS.equals(getIntentMethod(intent));
    }

    @Override
    public int getProcessorType() {
        return MESSAGE_TYPE_PUSH_SWITCH_STATUS;
    }
}
