package com.meizu.cloud.pushsdk.handler.impl.platform;

import android.content.Context;
import android.content.Intent;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.constants.PushConstants;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.notification.PushNotification;

/**
 * Created by liaojinlong on 16-9-27.
 */
public class ReceiveNotifyMessageHandler extends AbstractMessageHandler<String>{

    public ReceiveNotifyMessageHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    protected String getMessage(Intent intent) {
        return intent.getStringExtra(PushConstants.EXTRA_APP_PUSH_RESPONSE_NOTIFICATION_MESSAGE);
    }

    @Override
    protected void unsafeSend(String message, PushNotification pushNotification) {
        if(appLogicListener() != null && message != null){
            appLogicListener().onNotifyMessageArrived(context(),message);
        }
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i(TAG, "start ReceiveNotifyMessageHandler match");
        return PushConstants.MZ_PUSH_ON_MESSAGE_ACTION.equals(intent.getAction())
                && PushConstants.MZ_PUSH_MESSAGE_METHOD_ACTION_RESPONSE_NOTIFICATION_MESSAGE.equals(getIntentMethod(intent));
    }

    @Override
    public int getProcessorType() {
        return MESSAGE_TYPE_RECEIVE_NOTIFY_MESSAGE;
    }
}
