package com.meizu.cloud.pushsdk.handler.impl.schedule;

import android.content.Context;
import android.content.Intent;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.constants.PushConstants;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.MessageV3Handler;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.notification.StandardNotification;
import com.meizu.cloud.pushsdk.util.UxIPUtils;

/**
 * Show Message at schedule time
 */
public class ScheduleNotificationHandler extends MessageV3Handler{

    public ScheduleNotificationHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    protected MessageV3 getMessage(Intent intent) {
        return (MessageV3) intent.getParcelableExtra(PushConstants.EXTRA_APP_PUSH_SCHEDULE_NOTIFICATION_MESSAGE);
    }

    @Override
    protected void unsafeSend(MessageV3 message, PushNotification pushNotification) {
        if(pushNotification != null){
            pushNotification.show(message);
        }
    }


    @Override
    protected int scheduleNotificationStatus(MessageV3 message) {
        return SCHEDULE_OFF;
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i(TAG, "start ScheduleNotificationHandler match");
        return PushConstants.MZ_PUSH_ON_MESSAGE_ACTION.equals(intent.getAction())
                && PushConstants.MZ_PUSH_MESSAGE_METHOD_ACTION_SCHEDULE_NOTIFICATION.equals(getIntentMethod(intent));
    }

    @Override
    protected void onBeforeEvent(MessageV3 message) {
        DebugLogger.e(TAG,"ScheduleNotificationHandler dont repeat upload receiver push event");
    }

    @Override
    protected void onAfterEvent(MessageV3 message) {
        UxIPUtils.onShowPushMessageEvent(context(), message.getUploadDataPackageName(), message.getDeviceId(), message.getTaskId(), message.getSeqId(),message.getPushTimestamp());
    }

    @Override
    public int getProcessorType() {
        return MESSAGE_TYPE_SCHEDULE_NOTIFICATION;
    }
}
