package com.meizu.cloud.pushsdk.networking.http;

import java.io.IOException;


/**
 * Created by liaojinlong on 16-12-21.
 */
public interface Call {
    Request request();

    /**
     * Invokes the request immediately, and blocks until the response can be processed or is in
     * error.
     *
     * <p>The caller may read the response body with the response's {@link Response#body} method.  To
     * facilitate connection recycling, callers should always {@link ResponseBody#close() close the
     * response body}.
     *
     * <p>Note that transport-layer success (receiving a HTTP response code, headers and body) does
     * not necessarily indicate application-layer success: {@code response} may still indicate an
     * unhappy HTTP response code like 404 or 500.
     *
     * @throws IOException if the request could not be executed due to cancellation, a connectivity
     * problem or timeout. Because networks can fail during an exchange, it is possible that the
     * remote server accepted the request before the failure.
     * @throws IllegalStateException when the call has already been executed.
     */
    Response execute() throws IOException;

    /** Cancels the request, if possible. Requests that are already complete cannot be canceled. */
    void cancel();

    /**
     * Returns true if this call has been either {@linkplain #execute() executed} or {@linkplain}
     * It is an error to execute a call more than once.
     */
    boolean isExecuted();

    boolean isCanceled();
}
