package com.meizu.cloud.pushsdk.notification;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.widget.RemoteViews;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.notification.util.RProxy;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;

/**
 * Created by liaojinlong on 16-5-5.
 */
public class ExpandablePicNotification extends StandardNotification{
    private static final String TAG = "ExpandablePicNotification";

    public ExpandablePicNotification(Context context, PushNotificationBuilder pushNotificationBuilder) {
        super(context, pushNotificationBuilder);
    }


    @Override
    protected void buildBigContentView(Notification notification, MessageV3 messageV3) {
        if (MinSdkChecker.isSupportNotificationBuild()) {
            // Inflate and set the layout for the expanded notification view
            RemoteViews expandedView = new RemoteViews(context.getPackageName(), RProxy.push_expandable_big_image_notification(context));
            expandedView.setTextViewText(RProxy.push_big_notification_title(context),messageV3.getTitle());
            expandedView.setTextViewText(RProxy.push_big_notification_content(context), messageV3.getContent());
            expandedView.setLong(RProxy.push_big_notification_date(context), "setTime", System.currentTimeMillis());
            appLargeIconSetting(expandedView, messageV3);
            largeExpandableImageSetting(expandedView,messageV3);

            notification.bigContentView = expandedView;
        }
    }

    /**
     * setting expandable large pic
     * */
    private void largeExpandableImageSetting(RemoteViews expandedView,MessageV3 messageV3){
        if(messageV3.getmNotificationStyle() != null && !isOnMainThread()){
            if(!TextUtils.isEmpty(messageV3.getmNotificationStyle().getExpandableImageUrl())){
                Bitmap bitmap = getBitmapFromURL(messageV3.getmNotificationStyle().getExpandableImageUrl());
                if(bitmap != null){
                    expandedView.setViewVisibility(RProxy.push_big_bigview_defaultView(context), View.VISIBLE);
                    expandedView.setImageViewBitmap(RProxy.push_big_bigview_defaultView(context), bitmap);
                } else {
                    expandedView.setViewVisibility(RProxy.push_big_bigview_defaultView(context), View.GONE);
                }
            } else {
                expandedView.setViewVisibility(RProxy.push_big_bigview_defaultView(context), View.GONE);
            }
        }

    }

}
