package com.meizu.cloud.pushsdk.notification.android;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;

/**
 * Created by liaojinlong on 16-7-1.
 */
public class AndroidExpandablePicNotification extends AndroidStandardNotification{

    public AndroidExpandablePicNotification(Context context, PushNotificationBuilder pushNotificationBuilder) {
        super(context, pushNotificationBuilder);
    }

    @Override
    protected void buildExpandableContent(Notification.Builder builder, MessageV3 messageV3) {
        if(MinSdkChecker.isSupportNotificationBuild()){
            Notification.BigPictureStyle bigPictureStyle = new Notification.BigPictureStyle();
            if(messageV3.getmNotificationStyle() != null && !isOnMainThread()){
                if(!TextUtils.isEmpty(messageV3.getmNotificationStyle().getExpandableImageUrl())){
                    Bitmap bitmap = getBitmapFromURL(messageV3.getmNotificationStyle().getExpandableImageUrl());
                    if(bitmap != null){
                        bigPictureStyle.setBigContentTitle(messageV3.getTitle());
                        bigPictureStyle.setSummaryText(messageV3.getContent());
                        bigPictureStyle.bigPicture(bitmap);
                        builder.setStyle(bigPictureStyle);
                    }
                }
            }
        }
    }
}
