package com.meizu.cloud.pushsdk.notification.android;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.notification.AbstractPushNotification;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.notification.model.AppIconSetting;

/**
 * Created by liaojinlong on 16-7-1.
 */
public class AndroidStandardNotification extends AbstractPushNotification{

    public AndroidStandardNotification(Context context, PushNotificationBuilder pushNotificationBuilder) {
        super(context, pushNotificationBuilder);
    }

    /**
     * set largeIcon only out of mainThread
     * */
     @Override
     protected void appIconSettingBuilder(Notification.Builder builder, MessageV3 messageV3){
        final AppIconSetting appIconSetting = messageV3.getmAppIconSetting();
        if(appIconSetting != null){
            if(appIconSetting.isDefaultLargeIcon()){
                builder.setLargeIcon((pushNotificationBuilder != null && pushNotificationBuilder.getmLargIcon() != 0) ?
                        BitmapFactory.decodeResource(context.getResources(), pushNotificationBuilder.getmLargIcon()) : getAppIcon(context, messageV3.getPackageName()));
            } else {
                if(Thread.currentThread() != context.getMainLooper().getThread()){
                    Bitmap largeIcon = getBitmapFromURL(appIconSetting.getLargeIconUrl());
                    if(largeIcon != null){
                        DebugLogger.i(TAG, "On other Thread down load largeIcon image success");
                        builder.setLargeIcon(largeIcon);
                    } else {
                        builder.setLargeIcon(getAppIcon(context, messageV3.getPackageName()));
                    }
                }

            }
        }
    }
}
