package com.meizu.cloud.pushsdk.notification.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;

import org.json.JSONException;
import org.json.JSONObject;


/**
 * "advance_setting": {
     "network_type": 0,
     "notify_type": 0,
     "clear_notification": false,
     "head_up_notification": "false"
    }
 */
public class AdvanceSetting implements Parcelable{
    private int netWorkType = 1;
    /**
     * 0 : 震动
     * 1 : 闪灯
     * 2 : 声音
     * */
    private NotifyType notifyType;
    /**
     * 通知栏是否可清除
     * */
    private boolean clearNotification = true;
    /**
     * 是否支持悬浮窗功能
     * */
    private boolean headUpNotification = true;

    public static final String TAG = "advance_setting";

    public static final String ADVANCE_SETTING = "as";
    public static final String NETWORK_TYPE = "it";
    public static final String NOTIFY_TYPE = "nt";
    public static final String CLEAR_NOTIFICATION = "cn";
    public static final String HEAD_UP_NOTIFICATION = "hn";

    public static final Parcelable.Creator<AdvanceSetting> CREATOR
            = new Parcelable.Creator<AdvanceSetting>() {
        public AdvanceSetting createFromParcel(Parcel in) {
            return new AdvanceSetting(in);
        }

        public AdvanceSetting[] newArray(int size) {
            return new AdvanceSetting[size];
        }
    };

    public AdvanceSetting(){
        super();
    }

    public AdvanceSetting(Parcel in){
        netWorkType = in.readInt();
        notifyType = in.readParcelable(NotifyType.class.getClassLoader());
        clearNotification = in.readByte() != 0;
        headUpNotification = in.readByte() != 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flag) {
        parcel.writeInt(netWorkType);
        parcel.writeParcelable(notifyType, flag);
        parcel.writeByte((byte) (clearNotification ? 1 : 0));
        parcel.writeByte((byte) (headUpNotification ? 1 : 0));
    }





    public int getNetWorkType() {
        return netWorkType;
    }

    public void setNetWorkType(int netWorkType) {
        this.netWorkType = netWorkType;
    }

    public NotifyType getNotifyType() {
        return notifyType;
    }

    public void setNotifyType(NotifyType notifyType) {
        this.notifyType = notifyType;
    }

    public boolean isClearNotification() {
        return clearNotification;
    }

    public void setClearNotification(boolean clearNotification) {
        this.clearNotification = clearNotification;
    }

    public boolean isHeadUpNotification() {
        return headUpNotification;
    }

    public void setHeadUpNotification(boolean headUpNotification) {
        this.headUpNotification = headUpNotification;
    }

    public static AdvanceSetting parse(String setting){
        JSONObject advanceObj = null;
        if(!TextUtils.isEmpty(setting)){
            try {
                advanceObj  = new JSONObject(setting);
            } catch (JSONException e) {
                DebugLogger.e(TAG, "parse json string error " + e.getMessage());
            }
        }
        return parse(advanceObj);
    }

    public static AdvanceSetting parse(JSONObject advanceObj){
        AdvanceSetting advanceSetting = new AdvanceSetting();
        if(advanceObj != null){
            try {
                if(!advanceObj.isNull(NETWORK_TYPE)){
                    advanceSetting.setNetWorkType(advanceObj.getInt(NETWORK_TYPE));
                }
                if(!advanceObj.isNull(NOTIFY_TYPE)){
                    advanceSetting.setNotifyType(NotifyType.parse(advanceObj.getJSONObject(NotifyType.NOTIFY_TYPE)));
                }
                if(!advanceObj.isNull(CLEAR_NOTIFICATION)){
                    advanceSetting.setClearNotification(advanceObj.getInt(CLEAR_NOTIFICATION) != 0);
                }
                if(!advanceObj.isNull(HEAD_UP_NOTIFICATION)){
                    advanceSetting.setHeadUpNotification(advanceObj.getInt(HEAD_UP_NOTIFICATION) != 0);
                }
            } catch (JSONException e) {
                DebugLogger.e(TAG, "parse json obj error " + e.getMessage());
            }
        } else {
            DebugLogger.e(TAG,"no such tag "+TAG);
        }
        return advanceSetting;
    }

    @Override
    public String toString() {
        return "AdvanceSetting{" +
                "netWorkType=" + netWorkType +
                ", notifyType=" + notifyType +
                ", clearNotification=" + clearNotification +
                ", headUpNotification=" + headUpNotification +
                '}';
    }


}
