package com.meizu.cloud.pushsdk.notification.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;

/**
 * "app_icon_setting": {
     "default_large_icon": "true",
     "large_icon_url": ""
    }
 */
public class AppIconSetting implements Parcelable {
    public static final String TAG = "app_icon_setting";
    public static final String APP_ICON_SETTING = "is";
    public static final String DEFAULT_LARGE_ICON = "di";
    public static final String LARGE_ICON_URL = "li";
    /**
     * 是否使用应用默认的大图标
     * */
    private boolean defaultLargeIcon = true;
    /**
     * 应用大图标地址
     * */
    private String largeIconUrl;


    public static final Parcelable.Creator<AppIconSetting> CREATOR
            = new Parcelable.Creator<AppIconSetting>() {
        public AppIconSetting createFromParcel(Parcel in) {
            return new AppIconSetting(in);
        }

        public AppIconSetting[] newArray(int size) {
            return new AppIconSetting[size];
        }
    };

    public AppIconSetting(Parcel in){
        defaultLargeIcon = in.readByte() != 0;
        largeIconUrl = in.readString();
    }

    public AppIconSetting() {
        super();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeByte((byte) (defaultLargeIcon ? 1 : 0));
        parcel.writeString(largeIconUrl);
    }


    public String getLargeIconUrl() {
        return largeIconUrl;
    }

    public void setLargeIconUrl(String largeIconUrl) {
        this.largeIconUrl = largeIconUrl;
    }

    public boolean isDefaultLargeIcon() {
        return defaultLargeIcon;
    }

    public void setDefaultLargeIcon(boolean defaultLargeIcon) {
        this.defaultLargeIcon = defaultLargeIcon;
    }

    public static AppIconSetting parse(String setting){
        JSONObject appIconSetingObj = null;
        if(!TextUtils.isEmpty(setting)){
            try {
                appIconSetingObj = new JSONObject(setting);
            } catch (JSONException e) {
                DebugLogger.e(TAG, "parse json string error " + e.getMessage());
            }
        }
        return parse(appIconSetingObj);
    }

    public static AppIconSetting parse(JSONObject appIconSetingObj){
        AppIconSetting appIconSetting = new AppIconSetting();
        if(appIconSetingObj != null){
            try {
                if(!appIconSetingObj.isNull(DEFAULT_LARGE_ICON)){
                    appIconSetting.setDefaultLargeIcon(appIconSetingObj.getInt(DEFAULT_LARGE_ICON) != 0);
                }
                if(!appIconSetingObj.isNull(LARGE_ICON_URL)){
                    appIconSetting.setLargeIconUrl(appIconSetingObj.getString(LARGE_ICON_URL));
                }
            } catch (JSONException e) {
                DebugLogger.e(TAG, "parse json obj error " + e.getMessage());
            }
        } else {
            DebugLogger.e(TAG,"no such tag "+TAG);
        }
        return appIconSetting;
    }

    @Override
    public String toString() {
        return "AppIconSetting{" +
                "defaultLargeIcon=" + defaultLargeIcon +
                ", largeIconUrl='" + largeIconUrl + '\'' +
                '}';
    }


}
