package com.meizu.cloud.pushsdk.notification.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;

/**
 *
 * "notification_style": {
     "base_style": "0",
     "inner_style": "1",
     "expandable_text": "",
     "expandable_image_url": "",
     "banner_image_url": ""
    }
 */
public class NotificationStyle implements Parcelable {
    public static final String TAG = "notification_style";
    public static final String NOTIFICATION_STYLE = "ns";
    public static final String BASE_STYLE = "bs";
    public static final String INNER_STYLE = "is";
    public static final String EXPANDABLE_TEXT = "et";
    public static final String EXPANDABLE_IMAGE_URL = "ei";
    public static final String BANNER_IMAGE_URL = "bi";
    private int baseStyle = 0;
    private int innerStyle = 0;
    private String expandableText;
    private String expandableImageUrl;
    private String bannerImageUrl;

    public static final Parcelable.Creator<NotificationStyle> CREATOR
            = new Parcelable.Creator<NotificationStyle>() {
        public NotificationStyle createFromParcel(Parcel in) {
            return new NotificationStyle(in);
        }

        public NotificationStyle[] newArray(int size) {
            return new NotificationStyle[size];
        }
    };

    public NotificationStyle(Parcel in){
        baseStyle = in.readInt();
        innerStyle = in.readInt();
        expandableText = in.readString();
        expandableImageUrl = in.readString();
        bannerImageUrl = in.readString();
    }

    public NotificationStyle() {
        super();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(baseStyle);
        parcel.writeInt(innerStyle);
        parcel.writeString(expandableText);
        parcel.writeString(expandableImageUrl);
        parcel.writeString(bannerImageUrl);
    }

    public int getBaseStyle() {
        return baseStyle;
    }

    public void setBaseStyle(int baseStyle) {
        this.baseStyle = baseStyle;
    }

    public int getInnerStyle() {
        return innerStyle;
    }

    public void setInnerStyle(int innerStyle) {
        this.innerStyle = innerStyle;
    }

    public String getExpandableText() {
        return expandableText;
    }

    public void setExpandableText(String expandableText) {
        this.expandableText = expandableText;
    }

    public String getExpandableImageUrl() {
        return expandableImageUrl;
    }

    public void setExpandableImageUrl(String expandableImageUrl) {
        this.expandableImageUrl = expandableImageUrl;
    }

    public String getBannerImageUrl() {
        return bannerImageUrl;
    }

    public void setBannerImageUrl(String bannerImageUrl) {
        this.bannerImageUrl = bannerImageUrl;
    }

    public static NotificationStyle parse(String setting){
        JSONObject notificationObj = null;
        if(!TextUtils.isEmpty(setting)){
            try {
                notificationObj = new JSONObject(setting);
            } catch (JSONException e) {
                DebugLogger.e(TAG,"parse json string error "+e.getMessage());
            }
        }
        return parse(notificationObj);
    }

    public static NotificationStyle parse(JSONObject notificationObj){
        NotificationStyle notificationStyle = new NotificationStyle();
        if(notificationObj != null){
            try {
                if(!notificationObj.isNull(BASE_STYLE)){
                    notificationStyle.setBaseStyle(notificationObj.getInt(BASE_STYLE));
                }
                if(!notificationObj.isNull(INNER_STYLE)){
                    notificationStyle.setInnerStyle(notificationObj.getInt(INNER_STYLE));
                }
                if(!notificationObj.isNull(EXPANDABLE_TEXT)){
                    notificationStyle.setExpandableText(notificationObj.getString(EXPANDABLE_TEXT));
                }
                if(!notificationObj.isNull(EXPANDABLE_IMAGE_URL)){
                    notificationStyle.setExpandableImageUrl(notificationObj.getString(EXPANDABLE_IMAGE_URL));
                }
                if(!notificationObj.isNull(BANNER_IMAGE_URL)){
                    notificationStyle.setBannerImageUrl(notificationObj.getString(BANNER_IMAGE_URL));
                }
            } catch (JSONException e) {
                DebugLogger.e(TAG, "parse json obj error " + e.getMessage());
            }
        } else {
            DebugLogger.e(TAG,"no such tag "+TAG);
        }
        return notificationStyle;
    }

    @Override
    public String toString() {
        return "NotificationStyle{" +
                "baseStyle=" + baseStyle +
                ", innerStyle=" + innerStyle +
                ", expandableText='" + expandableText + '\'' +
                ", expandableImageUrl='" + expandableImageUrl + '\'' +
                ", bannerImageUrl='" + bannerImageUrl + '\'' +
                '}';
    }
}
