package com.meizu.cloud.pushsdk.notification.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;

/**
 *
 "time_display_setting": {
     "time_display": "false",
     "show_time": ""
  }
 */
public class TimeDisplaySetting implements Parcelable {
    public static final String TAG = "time_display_setting";
    public static final String TIME_DISPLAY_SETTING = "ts";
    public static final String TIME_DISPLAY = "td";
    public static final String START_SHOW_TIME = "st";
    public static final String END_SHOW_TIME ="et";
    private boolean isTimeDisplay;
    private String startShowTime;
    private String endShowTime;

    public static final Parcelable.Creator<TimeDisplaySetting> CREATOR
            = new Parcelable.Creator<TimeDisplaySetting>() {
        public TimeDisplaySetting createFromParcel(Parcel in) {
            return new TimeDisplaySetting(in);
        }

        public TimeDisplaySetting[] newArray(int size) {
            return new TimeDisplaySetting[size];
        }
    };

    public TimeDisplaySetting(Parcel in){
        isTimeDisplay = in.readByte() != 0;
        startShowTime = in.readString();
        endShowTime = in.readString();
    }

    public TimeDisplaySetting() {
        super();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeByte((byte) (isTimeDisplay ? 1 : 0));
        parcel.writeString(startShowTime);
        parcel.writeString(endShowTime);
    }

    public boolean isTimeDisplay() {
        return isTimeDisplay;
    }

    public void setIsTimeDisplay(boolean isTimeDisplay) {
        this.isTimeDisplay = isTimeDisplay;
    }

    public String getStartShowTime() {
        return startShowTime;
    }

    public void setStartShowTime(String startShowTime) {
        this.startShowTime = startShowTime;
    }

    public String getEndShowTime() {
        return endShowTime;
    }

    public void setEndShowTime(String endShowTime) {
        this.endShowTime = endShowTime;
    }

    public static TimeDisplaySetting parse(String setting){
        JSONObject timedisplayObj = null;
        if(!TextUtils.isEmpty(setting)){
            try {
                timedisplayObj =  new JSONObject(setting);
            } catch (JSONException e) {
                DebugLogger.e(TAG, "parse json string error " + e.getMessage());
            }
        }
        return parse(timedisplayObj);
    }

    public static TimeDisplaySetting parse(JSONObject timedisplayObj){
        TimeDisplaySetting timeDisplaySetting = new TimeDisplaySetting();
        if(timedisplayObj != null){
            try {
                if(!timedisplayObj.isNull(TIME_DISPLAY)){
                    timeDisplaySetting.setIsTimeDisplay(timedisplayObj.getInt(TIME_DISPLAY) != 0);
                }
                if(!timedisplayObj.isNull(START_SHOW_TIME)){
                    timeDisplaySetting.setStartShowTime(timedisplayObj.getString(START_SHOW_TIME));
                }
                if(!timedisplayObj.isNull(END_SHOW_TIME)){
                    timeDisplaySetting.setEndShowTime(timedisplayObj.getString(END_SHOW_TIME));
                }
            } catch (JSONException e) {
                DebugLogger.e(TAG, "parse json obj error " + e.getMessage());
            }
        } else {
            DebugLogger.e(TAG,"no such tag "+TAG);
        }

        return timeDisplaySetting;
    }

    @Override
    public String toString() {
        return "TimeDisplaySetting{" +
                "isTimeDisplay=" + isTimeDisplay +
                ", startShowTime='" + startShowTime + '\'' +
                ", endShowTime='" + endShowTime + '\'' +
                '}';
    }
}
