package com.meizu.cloud.pushsdk.platform.message;

import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;


import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;

/**
 * Push platform basic message
 */
public abstract class BasicPushStatus implements Serializable {
    public static final String TAG = "BasicPushStatus";
    public static final String SUCCESS_CODE = "200";
    /**
     * @param code
     *    push状态编码
     * */
    public String code;
    /**
     * 消息代码,包含错误原因编码
     *
     * */
    public String message;

    public BasicPushStatus(){

    }

    public BasicPushStatus(String json){
        JSONObject jsonObject = parse(json);
        if(jsonObject != null && SUCCESS_CODE.equals(code)){
            if(!jsonObject.isNull("value")){
                try {
                    parseValueData(jsonObject.getJSONObject("value"));
                } catch (JSONException e) {
                    DebugLogger.e(TAG,"parse value data error "+e.getMessage()+" json "+json);
                }
            }
        }
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return message;
    }

    /**
     * parse value data
     * */
    public abstract void parseValueData(JSONObject jsonObject) throws JSONException;

    protected JSONObject parse(String message){
        JSONObject jsonObject = null;
        if (!TextUtils.isEmpty(message)){
            try {
                jsonObject = new JSONObject(message);
                if(jsonObject != null){
                    if(!jsonObject.isNull("code")){
                        setCode(jsonObject.getString("code"));
                    }
                    if(!jsonObject.isNull("message")){
                        setMessage(jsonObject.getString("message"));
                    }
                }
            } catch (JSONException e) {
                DebugLogger.e(TAG,"covert json error "+e.getMessage());
            }
        }
        return jsonObject;
    }

    @Override
    public String toString() {
        return "BasicPushStatus{" +
                "code='" + code + '\'' +
                ", message='" + message + '\'' +
                '}';
    }
}
