package com.meizu.cloud.pushsdk.platform.message;


import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by liaojinlong on 16-4-20.
 */
public class PushSwitchStatus extends BasicPushStatus {

    /**
     *  通知栏消息开关
     *
     * */
    private boolean switchNotificationMessage;
    /**
     *  透传消息开关
     *
     * */
    private boolean switchThroughMessage;
    /**
     * 注册成功返回id,唯一标识一台设备在中的一个应用
     * */
    private String pushId;

    public PushSwitchStatus(String pushStatus) {
        super(pushStatus);
    }

    public PushSwitchStatus() {
        super();
    }

    @Override
    public void parseValueData(JSONObject jsonObject) throws JSONException {
        if(!jsonObject.isNull("pushId")){
            setPushId(jsonObject.getString("pushId"));
        }
        if(!jsonObject.isNull("barTypeSwitch")){
            setSwitchNotificationMessage(jsonObject.getInt("barTypeSwitch") == 1);
        }
        if(!jsonObject.isNull("directTypeSwitch")){
            setSwitchThroughMessage(jsonObject.getInt("directTypeSwitch") == 1);
        }
    }

    public boolean isSwitchNotificationMessage() {
        return switchNotificationMessage;
    }

    public void setSwitchNotificationMessage(boolean switchNotificationMessage) {
        this.switchNotificationMessage = switchNotificationMessage;
    }

    public boolean isSwitchThroughMessage() {
        return switchThroughMessage;
    }

    public void setSwitchThroughMessage(boolean switchThroughMessage) {
        this.switchThroughMessage = switchThroughMessage;
    }

    public String getPushId() {
        return pushId;
    }

    public void setPushId(String pushId) {
        this.pushId = pushId;
    }

    @Override
    public String toString() {
        return super.toString()+"PushSwitchStatus{" +
                "switchNotificationMessage=" + switchNotificationMessage +
                ", switchThroughMessage=" + switchThroughMessage +
                ", pushId='" + pushId + '\'' +
                '}';
    }
}
