package com.meizu.cloud.pushsdk.platform.message;


import org.json.JSONException;
import org.json.JSONObject;

public class RegisterStatus extends BasicPushStatus {
    private String pushId;
    //精确到秒
    private int expireTime;

    public RegisterStatus(){
        super();
    }
    public RegisterStatus(String responseJson) {
        super(responseJson);
    }

    @Override
    public void parseValueData(JSONObject jsonObject) throws JSONException {
        if(!jsonObject.isNull("pushId")){
            setPushId(jsonObject.getString("pushId"));
        }
        if(!jsonObject.isNull("expireTime")){
            setExpireTime(jsonObject.getInt("expireTime"));
        }
    }

    public String getPushId() {
        return pushId;
    }

    public void setPushId(String pushId) {
        this.pushId = pushId;
    }

    /**
     * pushId有效时长,精确到秒
     * */
    public int getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(int expireTime) {
        this.expireTime = expireTime;
    }

    @Override
    public String toString() {
        return super.toString() +
                "pushId='" + pushId + '\'' +
                ", Become invalid after " + expireTime + " seconds "+
                '}';
    }
}
