package com.meizu.cloud.pushsdk.platform.message;

import com.meizu.cloud.pushinternal.DebugLogger;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by liaojinlong on 16-5-20.
 */
public class SubTagsStatus extends BasicPushStatus{
    private String pushId;
    private List<Tag> tagList;

    public SubTagsStatus() {
        super();
    }

    public class Tag implements Serializable{
        private int tagId;
        private String tagName;

        @Override
        public String toString() {
            return "Tag{" +
                    "tagId=" + tagId +
                    ", tagName='" + tagName + '\'' +
                    '}';
        }

        public int getTagId() {
            return tagId;
        }

        public void setTagId(int tagId) {
            this.tagId = tagId;
        }

        public String getTagName() {
            return tagName;
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }
    }

    public SubTagsStatus(String json) {
        super(json);
    }

    @Override
    public void parseValueData(JSONObject jsonObject) throws JSONException {
        if(!jsonObject.isNull("pushId")){
            setPushId(jsonObject.getString("pushId"));
        }
        if(!jsonObject.isNull("tags")){
            JSONArray tagsArray = jsonObject.getJSONArray("tags");
            List<Tag> tags = new ArrayList<>();
            for(int i=0; i<tagsArray.length(); i++){
                JSONObject tagObj = tagsArray.getJSONObject(i);
                Tag tag = new Tag();
                if(!tagObj.isNull("tagId")){
                    tag.tagId = tagObj.getInt("tagId");
                }
                if(!tagObj.isNull("tagName")){
                    tag.tagName = tagObj.getString("tagName");
                }
                tags.add(tag);
            }
            DebugLogger.e(TAG,"tags "+tags);
            setTagList(tags);
        }
    }

    public String getPushId() {
        return pushId;
    }

    public void setPushId(String pushId) {
        this.pushId = pushId;
    }

    public List<Tag> getTagList() {
        return tagList;
    }

    public void setTagList(List<Tag> tagList) {
        this.tagList = tagList;
    }

    @Override
    public String toString() {
        return super.toString()+" SubTagsStatus{" +
                "pushId='" + pushId + '\'' +
                ", tagList=" + tagList +
                '}';
    }
}
