package com.meizu.cloud.pushsdk.pushtracer;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.common.util.Utility;
import com.meizu.cloud.pushsdk.pushtracer.emitter.BufferOption;
import com.meizu.cloud.pushsdk.pushtracer.emitter.Emitter;
import com.meizu.cloud.pushsdk.pushtracer.emitter.RequestCallback;
import com.meizu.cloud.pushsdk.pushtracer.tracker.Subject;
import com.meizu.cloud.pushsdk.pushtracer.tracker.Tracker;
import com.meizu.cloud.pushsdk.pushtracer.utils.LogLevel;
import com.meizu.cloud.pushsdk.pushtracer.utils.Logger;
import com.meizu.cloud.pushsdk.pushtracer.utils.Util;


/**
 * build Tracker quick method
 * receive network change status and restart upload data
 */
public class QuickTracker {
    public static final String namespace = "PushAndroidTracker";
    private static Tracker tracker;
    /**
     * Returns a Classic Tracker
     *
     * @param context the application context
     * @param callback the emitter callback
     * @return a new Classic Tracker
     */
    public static Tracker getAndroidTrackerClassic(Context context, RequestCallback callback) {
        Subject subject = getSubject(context);
        if (tracker == null) {
            synchronized (QuickTracker.class) {
                if (tracker == null) {
                    Emitter emitter = getEmitterClassic(context, callback);
                    tracker = getTrackerClassic(emitter, subject, context);
                    registerNetworkReceiver(context,tracker);
                    tracker.setSubject(subject);
                }
            }
        }
        return tracker;
    }

    /**
     * Returns a Classic Tracker
     *
     * @param emitter a Classic emitter
     * @param subject the tracker subject
     * @return a new Classic Tracker
     */
    private static Tracker getTrackerClassic(Emitter emitter, Subject subject, Context context) {
        return new com.meizu.cloud.pushsdk.pushtracer.tracker.classic.Tracker(new Tracker.TrackerBuilder(emitter, namespace, context.getPackageCodePath(), context,
                com.meizu.cloud.pushsdk.pushtracer.tracker.classic.Tracker.class)
                .level(LogLevel.VERBOSE)
                .base64(false)
                .subject(subject)
                .threadCount(2));
    }


    /**
     * Returns a Classic Emitter
     *
     * @param context the application context
     * @param callback the emitter callback
     * @return a new Classic Emitter
     */
    private static Emitter getEmitterClassic(Context context, RequestCallback callback) {
        return new com.meizu.cloud.pushsdk.pushtracer.emitter.classic.Emitter(new Emitter.EmitterBuilder(getStaticsDomain(), context,
                com.meizu.cloud.pushsdk.pushtracer.emitter.classic.Emitter.class)
                .callback(callback)
                .tick(1)
                .option(BufferOption.Single)
                .sendLimit(1)
                .emptyLimit(2));
    }

    /**
     * Returns a Subject Object
     *
     * @param context the application context
     * @return a new subject
     */
    private static Subject getSubject(Context context) {
        return new Subject
                .SubjectBuilder()
                .context(context)
                .build();
    }

    /**
     * register network status receiver
     * when network connected, upload tracker data
     * @param  context
     * @param tracker
     *
     * **/
    private static void registerNetworkReceiver(Context context, final Tracker tracker){
        IntentFilter filter = new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION);
        context.registerReceiver(new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                  if(Util.isOnline(context)){
                      Logger.e("QuickTracker", "restart track event: %s","online true");
                      tracker.restartEventTracking();
                  }
            }
        },filter);
    }

    private static String getStaticsDomain(){
        String staticsDomian = "push-statics.meizu.com";
        if(Utility.isInternational() || Utility.isIndiaLocal()){
            return "push-statics.in.meizu.com";
        }
        DebugLogger.e("QuickTracker","current statics domain is "+staticsDomian);
        return staticsDomian;
    }
}
