package com.meizu.cloud.pushsdk.pushtracer.dataload;

import java.util.Map;

/**
 * Created by liaojinlong on 16-4-14.
 */
public interface DataLoad {
    /**
     * Add a basic parameter.
     *
     * @param key The parameter key
     * @param value The parameter value as a String
     */
    void add(String key, String value);

    /**
     * Add a basic parameter.
     *
     * @param key The parameter key
     * @param value The parameter value
     */
    void add(String key, Object value);

    /**
     * Add all the mappings from the specified map. The effect is the equivalent to that of calling
     * add(String key, Object value) for each mapping for each key.
     *
     * @param map Mappings to be stored in this map
     */
    void addMap(Map<String, Object> map);

    /**
     * Add a map to the DataLoad with a key dependent on the base 64 encoding option you choose using the
     * two keys provided.
     *
     * @param map Mapping to be stored
     * @param base64_encoded The option you choose to encode the data
     * @param type_encoded The key that would be set if the encoding option was set to true
     * @param type_no_encoded They key that would be set if the encoding option was set to false
     */
    void addMap(Map map, Boolean base64_encoded, String type_encoded, String type_no_encoded);

    /**
     * Returns the DataLoad as a HashMap.
     *
     * @return A HashMap
     */
    Map getMap();

    /**
     * Returns the DataLoad as a string. This is essentially the toString from the ObjectNode used
     * to store the DataLoad.
     *
     * @return A string value of the DataLoad.
     */
    String toString();

    /**
     * Returns the byte size of a DataLoad.
     *
     * @return A long representing the byte size of the DataLoad.
     */
    long getByteSize();
}
