package com.meizu.cloud.pushsdk.pushtracer.dataload;

import com.meizu.cloud.pushsdk.pushtracer.utils.Logger;
import com.meizu.cloud.pushsdk.pushtracer.utils.Util;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by liaojinlong on 16-4-14.
 */
public class TrackerDataload implements DataLoad{
    private final String TAG = TrackerDataload.class.getSimpleName();
    private final HashMap<String,Object> dataload = new HashMap<String,Object>();

    @Override
    public void add(String key, String value) {
        if (value == null || value.isEmpty()) {
            Logger.i(TAG, "The keys value is empty, returning without adding key: " + key);
            return;
        }
        //Logger.i(TAG, "Adding new kv pair: " + key + "->" + value);
        dataload.put(key, value);
    }

    @Override
    public void add(String key, Object value) {
        if (value == null) {
            Logger.i(TAG, "The keys value is empty, returning without adding key: "+key);
            return;
        }
        //Logger.i(TAG, "Adding new kv pair: " + key + "->" + value);
        dataload.put(key, value);
    }

    @Override
    public void addMap(Map<String, Object> map) {
        if (map == null) {
            Logger.i(TAG, "Map passed in is null, returning without adding map.");
            return;
        }
        //Logger.i(TAG, "Adding new map: "+map);
        dataload.putAll(map);
    }

    @Override
    public void addMap(Map map, Boolean base64_encoded, String type_encoded, String type_no_encoded) {
        // Return if we don't have a map
        if (map == null) {
            Logger.i(TAG, "Map passed in is null, returning nothing.");
            return;
        }

        String mapString = Util.mapToJSONObject(map).toString();
        Logger.i(TAG, "Adding new map: "+mapString);

        if (base64_encoded) { // base64 encoded data
            add(type_encoded, Util.base64Encode(mapString));
        } else { // add it as a child node
            add(type_no_encoded, mapString);
        }
    }

    public Map getMap() {
        return dataload;
    }

    public String toString() {
        return Util.mapToJSONObject(dataload).toString();
    }

    public long getByteSize() {
        return Util.getUTF8Length(toString());
    }
}
