package com.meizu.cloud.pushsdk.pushtracer.emitter;


import com.meizu.cloud.pushsdk.networking.http.Request;

import java.util.LinkedList;


/**
 * Class to house a request that is ready
 * to be sent.  Allows for easier abstraction
 * between synchronous and asynchronous
 * sending.
 */
public class ReadyRequest {
    private final boolean oversize;
    private final Request request;
    private final LinkedList<Long> ids;

    /**
     * Constructs a ReadyRequest
     *
     * @param oversize if the request is over-sized
     * @param request the request to send
     * @param ids the ids associated with the request
     */
    public ReadyRequest(boolean oversize, Request request, LinkedList<Long> ids) {
        this.oversize = oversize;
        this.request = request;
        this.ids = ids;
    }

    /**
     * @return the request for sending
     */
    public Request getRequest() {
        return this.request;
    }

    /**
     * @return the list of event ids
     */
    public LinkedList<Long> getEventIds() {
        return this.ids;
    }

    /**
     * @return if the request is over-sized
     */
    public boolean isOversize() {
        return this.oversize;
    }
}
