package com.meizu.cloud.pushsdk.pushtracer.emitter.classic;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/**
 * Created by liaojinlong on 16-4-14.
 */
public class Executor {
    private static ExecutorService executor;
    private static int threadCount = 2; // Minimum amount of threads.

    /**
     * If the executor is null creates a
     * new executor.
     *
     * @return the executor
     */
    private static ExecutorService getExecutor() {
        synchronized (Executor.class) {
            if (executor == null) {
                executor = Executors.newScheduledThreadPool(threadCount);
            }
        }
        return executor;
    }

    /**
     * Sends a runnable to the executor service.
     *
     * @param runnable the runnable to be queued
     */
    public static void execute(Runnable runnable) {
        getExecutor().execute(runnable);
    }

    /**
     * Sends a callable to the executor service and
     * returns a Future.
     *
     * @param callable the callable to be queued
     * @return the future object to be queried
     */
    public static Future futureCallable(Callable callable) {
        return getExecutor().submit(callable);
    }

    /**
     * Shuts the executor service down and resets
     * the executor to a null state.
     */
    public static void shutdown() {
        if (executor != null) {
            executor.shutdown();
            executor = null;
        }
    }

    /**
     * Returns the status of the executor.
     *
     * @return executor is alive or not
     */
    public static boolean status() {
        return !(executor == null || executor.isShutdown());
    }

    /**
     * Changes the amount of threads the
     * scheduler will be able to use.
     *
     * NOTE: This can only be set before the
     * scheduler is first accessed, after this
     * point the function will not effect anything.
     *
     * @param count the thread count
     */
    public static void setThreadCount(final int count) {
        threadCount = count;
    }
}
