/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushinternal.R;
import com.meizu.cloud.pushsdk.PushMessageProxy;
import com.meizu.cloud.pushsdk.base.thread.MessageExecutorUtils;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.MzPushMessage;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.message.SubAliasStatus;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;
import com.meizu.cloud.pushsdk.platform.message.UnRegisterStatus;

public abstract class MzPushMessageReceiver
extends BroadcastReceiver {
    private static final String TAG = "MzPushMessageReceiver";
    private static boolean bInitLog = false;

    public void onReceive(Context context, final Intent intent) {
        final Context applicationContext = context.getApplicationContext();
        MessageExecutorUtils.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                if (!bInitLog) {
                    bInitLog = true;
                    DebugLogger.init(applicationContext);
                }
                MzPushMessageReceiver.this.onHandleIntent(applicationContext, intent);
            }
        });
    }

    private void onHandleIntent(Context context, Intent intent) {
        AbstractAppLogicListener abstractAppLogicListener = this.getAbstractAppLogicListener();
        PushMessageProxy.with(context).receiverListener(TAG, abstractAppLogicListener).processMessage(intent);
    }

    private AbstractAppLogicListener getAbstractAppLogicListener() {
        return new AbstractAppLogicListener(){

            @Override
            public void onRegister(Context context, String pushId) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onRegister " + pushId);
                MzPushMessageReceiver.this.onRegister(context, pushId);
            }

            @Override
            public void onUnRegister(Context context, boolean success) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onUnRegister " + success);
                MzPushMessageReceiver.this.onUnRegister(context, success);
            }

            @Override
            public void onMessage(Context context, Intent intent) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onMessage Flyme3 " + intent);
                MzPushMessageReceiver.this.onMessage(context, intent);
            }

            @Override
            public void onMessage(Context context, String message) {
                MzPushMessageReceiver.this.onMessage(context, message);
                DebugLogger.i(MzPushMessageReceiver.TAG, "receive message " + message);
            }

            @Override
            public void onMessage(Context context, String message, String platformExtra) {
                MzPushMessageReceiver.this.onMessage(context, message, platformExtra);
                DebugLogger.i(MzPushMessageReceiver.TAG, "receive message " + message + " platformExtra " + platformExtra);
            }

            @Override
            public void onUpdateNotificationBuilder(PushNotificationBuilder pushNotificationBuilder) {
                MzPushMessageReceiver.this.onUpdateNotificationBuilder(pushNotificationBuilder);
            }

            @Override
            public void onPushStatus(Context context, PushSwitchStatus pushSwitchStatus) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onPushStatus " + pushSwitchStatus);
                MzPushMessageReceiver.this.onPushStatus(context, pushSwitchStatus);
            }

            @Override
            public void onRegisterStatus(Context context, RegisterStatus registerStatus) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onRegisterStatus " + registerStatus);
                MzPushMessageReceiver.this.onRegisterStatus(context, registerStatus);
            }

            @Override
            public void onUnRegisterStatus(Context context, UnRegisterStatus unRegisterStatus) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onUnRegisterStatus " + unRegisterStatus);
                MzPushMessageReceiver.this.onUnRegisterStatus(context, unRegisterStatus);
            }

            @Override
            public void onSubTagsStatus(Context context, SubTagsStatus subTagsStatus) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onSubTagsStatus " + subTagsStatus);
                MzPushMessageReceiver.this.onSubTagsStatus(context, subTagsStatus);
            }

            @Override
            public void onSubAliasStatus(Context context, SubAliasStatus subAliasStatus) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onSubAliasStatus " + subAliasStatus);
                MzPushMessageReceiver.this.onSubAliasStatus(context, subAliasStatus);
            }

            @Override
            public void onNotificationClicked(Context context, MzPushMessage mzPushMessage) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onNotificationClicked title " + mzPushMessage.getTitle() + "content " + mzPushMessage.getContent() + " selfDefineContentString " + mzPushMessage.getSelfDefineContentString());
                MzPushMessageReceiver.this.onNotificationClicked(context, mzPushMessage);
            }

            @Override
            public void onNotificationArrived(Context context, MzPushMessage mzPushMessage) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onNotificationArrived title " + mzPushMessage.getTitle() + "content " + mzPushMessage.getContent() + " selfDefineContentString " + mzPushMessage.getSelfDefineContentString());
                MzPushMessageReceiver.this.onNotificationArrived(context, mzPushMessage);
            }

            @Override
            public void onNotificationDeleted(Context context, MzPushMessage mzPushMessage) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onNotificationDeleted title " + mzPushMessage.getTitle() + "content " + mzPushMessage.getContent() + " selfDefineContentString " + mzPushMessage.getSelfDefineContentString());
                MzPushMessageReceiver.this.onNotificationDeleted(context, mzPushMessage);
            }

            @Override
            public void onNotifyMessageArrived(Context context, String message) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onNotifyMessageArrived " + message);
                MzPushMessageReceiver.this.onNotifyMessageArrived(context, message);
            }
        };
    }

    @Deprecated
    public void onRegister(Context context, String pushId) {
    }

    public void onMessage(Context context, String message) {
    }

    public void onMessage(Context context, String message, String platformExtra) {
    }

    public void onMessage(Context context, Intent intent) {
    }

    @Deprecated
    public void onUnRegister(Context context, boolean success) {
    }

    public void onUpdateNotificationBuilder(PushNotificationBuilder pushNotificationBuilder) {
        pushNotificationBuilder.setStatusBarIcon(R.drawable.stat_sys_third_app_notify);
    }

    public void onNotificationClicked(Context context, MzPushMessage mzPushMessage) {
    }

    public void onNotificationArrived(Context context, MzPushMessage mzPushMessage) {
    }

    public void onNotificationDeleted(Context context, MzPushMessage mzPushMessage) {
    }

    public void onNotifyMessageArrived(Context context, String message) {
    }

    public abstract void onRegisterStatus(Context var1, RegisterStatus var2);

    public abstract void onUnRegisterStatus(Context var1, UnRegisterStatus var2);

    public abstract void onPushStatus(Context var1, PushSwitchStatus var2);

    public abstract void onSubTagsStatus(Context var1, SubTagsStatus var2);

    public abstract void onSubAliasStatus(Context var1, SubAliasStatus var2);
}

