/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.pushtracer.QuickTracker;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import java.util.List;

public class PullUpPush {
    private static final String TAG = "PullUpPush";

    public static void pushServiceStart(Context context) {
        String pushPackageName;
        String string = pushPackageName = MzSystemUtils.isWatch() ? "com.meizu.wearable.cloud" : "com.meizu.cloud";
        if (context.getPackageName().equalsIgnoreCase(pushPackageName)) {
            return;
        }
        PullUpPush.restartCloudService(context);
        PullUpPush.restartEventTracking(context);
    }

    private static void restartCloudService(Context context) {
        String pushPackageName = MzSystemUtils.isWatch() ? "com.meizu.wearable.cloud" : "com.meizu.cloud";
        String cloudVersionName = MzSystemUtils.getAppVersionName(context, pushPackageName);
        DebugLogger.i(TAG, context.getPackageName() + " start register cloudVersion_name " + cloudVersionName);
        Intent pushServiceIntent = new Intent();
        if (pushPackageName.equals(MzSystemUtils.getMzPushServicePackageName(context))) {
            DebugLogger.e(TAG, "cloud pushService start");
            pushServiceIntent.setAction("com.meizu.pushservice.action.START");
            pushServiceIntent.setClassName(pushPackageName, "com.meizu.cloud.pushsdk.pushservice.MzPushService");
        } else if (!TextUtils.isEmpty((CharSequence)cloudVersionName) && MzSystemUtils.compareVersion(cloudVersionName, "4.5.7")) {
            DebugLogger.e(TAG, "flyme 4.x start register cloud versionName " + cloudVersionName);
            pushServiceIntent.setPackage(pushPackageName);
            pushServiceIntent.setAction("com.meizu.flyme.push.intent.REGISTER");
        } else if (!TextUtils.isEmpty((CharSequence)cloudVersionName) && cloudVersionName.startsWith("3")) {
            DebugLogger.e(TAG, "flyme 3.x start register cloud versionName " + cloudVersionName);
            pushServiceIntent.setAction("com.meizu.c2dm.intent.REGISTER");
            pushServiceIntent.setPackage(pushPackageName);
        } else {
            DebugLogger.e(TAG, context.getPackageName() + " start register ");
            pushServiceIntent.setClassName(context.getPackageName(), "com.meizu.cloud.pushsdk.pushservice.MzPushService");
            pushServiceIntent.setAction("com.meizu.pushservice.action.START");
        }
        try {
            context.startService(pushServiceIntent);
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "start service error " + e.getMessage());
        }
    }

    private static void restartEventTracking(Context context) {
        if (Build.VERSION.SDK_INT > 22) {
            return;
        }
        Intent localIntent = new Intent("com.meizu.cloud.pushservice.action.PUSH_TRACKER_SERVICE");
        List serviceList = context.getPackageManager().queryIntentServices(localIntent, 0);
        if (serviceList == null || serviceList.size() == 0) {
            QuickTracker.init(context, false).restartEventTracking();
        }
    }
}

