/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk;

import android.content.Context;
import android.content.Intent;
import android.util.SparseArray;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.MessageHandler;
import com.meizu.cloud.pushsdk.handler.MzPushMessage;
import com.meizu.cloud.pushsdk.handler.impl.Advertisement.AdNotification;
import com.meizu.cloud.pushsdk.handler.impl.MessageV2Handler;
import com.meizu.cloud.pushsdk.handler.impl.MessageV3Handler;
import com.meizu.cloud.pushsdk.handler.impl.RegisterMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.ThroughMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.UnRegisterMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.fileupload.LogUploadMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.notification.NotificationArrivedHandler;
import com.meizu.cloud.pushsdk.handler.impl.notification.NotificationClickMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.notification.NotificationCloseMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.notification.NotificationDeleteMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.notification.NotificationStateMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.notification.WithDrawMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.platform.PushSwitchStatusHandler;
import com.meizu.cloud.pushsdk.handler.impl.platform.ReceiveNotifyMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.platform.RegisterStatusHandler;
import com.meizu.cloud.pushsdk.handler.impl.platform.SubScribeAliasStatusHandler;
import com.meizu.cloud.pushsdk.handler.impl.platform.SubScribeTagsStatusHandler;
import com.meizu.cloud.pushsdk.handler.impl.platform.UnRegisterStatusHandler;
import com.meizu.cloud.pushsdk.handler.impl.schedule.BrightNotification;
import com.meizu.cloud.pushsdk.handler.impl.schedule.BrightNotificationHandler;
import com.meizu.cloud.pushsdk.handler.impl.schedule.ScheduleNotificationHandler;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.message.SubAliasStatus;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;
import com.meizu.cloud.pushsdk.platform.message.UnRegisterStatus;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PushMessageProxy {
    private static final String TAG = "PushMessageProxy";
    private final SparseArray<MessageHandler> managerHashMap = new SparseArray();
    private static volatile PushMessageProxy singleton = null;
    private Map<String, AbstractAppLogicListener> messageListenerMap;
    private BrightNotification mBrightNotification;
    private AdNotification mAdNotification;

    public PushMessageProxy(Context context) {
        this(context, null);
    }

    public PushMessageProxy(Context context, List<MessageHandler> messageManagerList) {
        this(context, messageManagerList, null);
    }

    public PushMessageProxy(Context context, List<MessageHandler> messageManagerList, AbstractAppLogicListener listener) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null.");
        }
        Context applicationContext = context.getApplicationContext();
        this.messageListenerMap = new HashMap<String, AbstractAppLogicListener>();
        DefaultPushMessageListener abstractAppLogicListener = new DefaultPushMessageListener();
        if ("com.meizu.cloud".equalsIgnoreCase(applicationContext.getPackageName())) {
            this.mBrightNotification = new BrightNotification(applicationContext);
            if (MinSdkChecker.isSupportNotificationSort()) {
                this.mAdNotification = new AdNotification(applicationContext);
            }
        }
        if (messageManagerList == null) {
            this.addHandler(new MessageV3Handler(applicationContext, abstractAppLogicListener));
            this.addHandler(new MessageV2Handler(applicationContext, abstractAppLogicListener));
            this.addHandler(new ThroughMessageHandler(applicationContext, abstractAppLogicListener));
            this.addHandler(new NotificationClickMessageHandler(applicationContext, abstractAppLogicListener));
            this.addHandler(new RegisterMessageHandler(applicationContext, abstractAppLogicListener));
            this.addHandler(new UnRegisterMessageHandler(applicationContext, abstractAppLogicListener));
            this.addHandler(new NotificationDeleteMessageHandler(applicationContext, abstractAppLogicListener));
            this.addHandler(new PushSwitchStatusHandler(applicationContext, abstractAppLogicListener));
            this.addHandler(new RegisterStatusHandler(applicationContext, abstractAppLogicListener));
            this.addHandler(new UnRegisterStatusHandler(applicationContext, abstractAppLogicListener));
            this.addHandler(new SubScribeAliasStatusHandler(applicationContext, abstractAppLogicListener));
            this.addHandler(new SubScribeTagsStatusHandler(applicationContext, abstractAppLogicListener));
            this.addHandler(new ScheduleNotificationHandler(applicationContext, abstractAppLogicListener));
            this.addHandler(new ReceiveNotifyMessageHandler(applicationContext, abstractAppLogicListener));
            this.addHandler(new NotificationStateMessageHandler(applicationContext, abstractAppLogicListener));
            this.addHandler(new LogUploadMessageHandler(applicationContext, abstractAppLogicListener));
            this.addHandler(new NotificationArrivedHandler(applicationContext, abstractAppLogicListener));
            this.addHandler(new WithDrawMessageHandler(applicationContext, abstractAppLogicListener));
            this.addHandler(new BrightNotificationHandler(applicationContext, abstractAppLogicListener));
            this.addHandler(new NotificationCloseMessageHandler(applicationContext, abstractAppLogicListener));
        } else {
            this.addHandler(messageManagerList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PushMessageProxy with(Context context) {
        if (singleton != null) return singleton;
        Class<PushMessageProxy> clazz = PushMessageProxy.class;
        synchronized (PushMessageProxy.class) {
            if (singleton != null) return singleton;
            DebugLogger.i(TAG, "PushMessageProxy init");
            singleton = new PushMessageProxy(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public PushMessageProxy receiverListener(String tag, AbstractAppLogicListener abstractAppLogicListener) {
        this.messageListenerMap.put(tag, abstractAppLogicListener);
        return this;
    }

    public PushMessageProxy unReceiverListener(String tag) {
        this.messageListenerMap.put(tag, null);
        return this;
    }

    public PushMessageProxy addHandler(MessageHandler messageManager) {
        this.managerHashMap.put(messageManager.getProcessorType(), (Object)messageManager);
        return this;
    }

    public PushMessageProxy addHandler(List<MessageHandler> messageManagerList) {
        if (messageManagerList == null) {
            throw new IllegalArgumentException("messageManagerList must not be null.");
        }
        for (MessageHandler messageManager : messageManagerList) {
            this.addHandler(messageManager);
        }
        return this;
    }

    public void processMessage(Intent intent) {
        DebugLogger.e(TAG, "process message start");
        try {
            MessageHandler messageManager;
            boolean mathResult;
            String method = intent.getStringExtra("method");
            DebugLogger.i(TAG, "receive action " + intent.getAction() + " method " + method);
            for (int i = 0; i < this.managerHashMap.size() && !(mathResult = (messageManager = (MessageHandler)this.managerHashMap.valueAt(i)).sendMessage(intent)); ++i) {
            }
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "process message error " + e.getMessage());
        }
    }

    public BrightNotification getBrightNotification() {
        return this.mBrightNotification;
    }

    public AdNotification getAdNotification() {
        return this.mAdNotification;
    }

    public class DefaultPushMessageListener
    extends AbstractAppLogicListener {
        @Override
        public void onMessage(Context context, Intent intent) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onMessage(context, intent);
            }
        }

        @Override
        public void onRegister(Context context, String pushId) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onRegister(context, pushId);
            }
        }

        @Override
        public void onMessage(Context context, String message) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onMessage(context, message);
            }
        }

        @Override
        public void onMessage(Context context, String message, String platformExtra) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onMessage(context, message, platformExtra);
            }
        }

        @Override
        public void onUnRegister(Context context, boolean success) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onUnRegister(context, success);
            }
        }

        @Override
        public void onUpdateNotificationBuilder(PushNotificationBuilder pushNotificationBuilder) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onUpdateNotificationBuilder(pushNotificationBuilder);
            }
        }

        @Override
        public void onPushStatus(Context context, PushSwitchStatus pushSwitchStatus) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onPushStatus(context, pushSwitchStatus);
            }
        }

        @Override
        public void onRegisterStatus(Context context, RegisterStatus registerStatus) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onRegisterStatus(context, registerStatus);
            }
        }

        @Override
        public void onUnRegisterStatus(Context context, UnRegisterStatus unRegisterStatus) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onUnRegisterStatus(context, unRegisterStatus);
            }
        }

        @Override
        public void onSubTagsStatus(Context context, SubTagsStatus subTagsStatus) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onSubTagsStatus(context, subTagsStatus);
            }
        }

        @Override
        public void onSubAliasStatus(Context context, SubAliasStatus subAliasStatus) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onSubAliasStatus(context, subAliasStatus);
            }
        }

        @Override
        public void onNotificationClicked(Context context, MzPushMessage mzPushMessage) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onNotificationClicked(context, mzPushMessage);
            }
        }

        @Override
        public void onNotificationArrived(Context context, MzPushMessage mzPushMessage) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onNotificationArrived(context, mzPushMessage);
            }
        }

        @Override
        public void onNotificationDeleted(Context context, MzPushMessage mzPushMessage) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onNotificationDeleted(context, mzPushMessage);
            }
        }

        @Override
        public void onNotifyMessageArrived(Context context, String message) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onNotifyMessageArrived(context, message);
            }
        }
    }
}

