/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.analytics;

import android.content.Context;
import com.meizu.cloud.pushsdk.analytics.PayloadSub;
import com.meizu.cloud.pushsdk.analytics.secure.HttpSecureRequester;
import com.meizu.cloud.pushsdk.base.thread.IOExecutorUtils;
import com.meizu.cloud.pushsdk.pushtracer.dataload.TrackerDataload;
import java.util.Map;

public class FastTracker {
    public static TrackerDataload buildDataLoad(Context context) {
        TrackerDataload trackerDataload = new TrackerDataload();
        PayloadSub payloadSub = FastTracker.getPayloadSubject(context);
        Map<String, String> deviceInfoSubject = payloadSub.getDeviceInfoSubject();
        Map<String, Object> appInfoSubject = payloadSub.getAppInfoSubject();
        Map<String, Object> locationInfoSubject = payloadSub.getLocationInfoSubject();
        if (deviceInfoSubject.size() > 0) {
            trackerDataload.add("di", deviceInfoSubject);
        }
        if (appInfoSubject.size() > 0) {
            trackerDataload.add("ai", appInfoSubject);
        }
        if (locationInfoSubject.size() > 0) {
            trackerDataload.add("li", locationInfoSubject);
        }
        return trackerDataload;
    }

    public static void uploadData(final Context context) {
        IOExecutorUtils.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                TrackerDataload trackerDataload = FastTracker.buildDataLoad(context);
                HttpSecureRequester.getInstance(context).stringPartRequest("POST", null, trackerDataload.toString());
            }
        });
    }

    private static PayloadSub getPayloadSubject(Context context) {
        return new PayloadSub.PayloadSubBuilder().context(context).build();
    }
}

