/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.analytics;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.pushtracer.utils.Util;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import java.util.HashMap;
import java.util.Map;

public class PayloadSub {
    private static final String TAG = PayloadSub.class.getSimpleName();
    private final HashMap<String, String> deviceInfoPairs = new HashMap();
    private final HashMap<String, Object> appInfoPairs = new HashMap();
    private final HashMap<String, Object> locationPairs = new HashMap();

    private PayloadSub(PayloadSubBuilder builder) {
        this.setDeviceInfo();
        if (builder.context != null) {
            this.setTelephonyContext(builder.context);
            this.setDefaultScreenResolution(builder.context);
            this.setConnectivityContext(builder.context);
            this.setAppInfoContext(builder.context);
        }
        DebugLogger.i(TAG, "Subject created successfully.");
    }

    private void setDeviceInfo() {
        this.addDeviceInfoContext("br", Build.BRAND);
        this.addDeviceInfoContext("dc", Build.MODEL);
        this.addDeviceInfoContext("ot", Build.VERSION.RELEASE);
        this.addDeviceInfoContext("ov", Build.DISPLAY);
        this.addDeviceInfoContext("ll", MzSystemUtils.getCurrentLanguage());
    }

    private void setTelephonyContext(Context context) {
        this.addDeviceInfoContext("op", Util.getOperator(context));
    }

    public void setDefaultScreenResolution(Context context) {
        Point point = Util.getDefaultScreenResolution(context);
        if (point == null) {
            DebugLogger.e(TAG, "screen information not available.");
        } else {
            this.setScreenResolution("ss", point.x, point.y);
        }
    }

    private void setConnectivityContext(Context context) {
        this.addLocationInfoContext("nt", MzSystemUtils.getNetWorkType(context));
    }

    private void setAppInfoContext(Context context) {
        this.addAppInfoContext("pn", context.getPackageName());
        this.addAppInfoContext("pv", MzSystemUtils.getAppVersionName(context));
        this.addAppInfoContext("pvc", MzSystemUtils.getAppVersionCode(context));
        this.addAppInfoContext("st", TextUtils.isEmpty((CharSequence)MzSystemUtils.findReceiver(context, "com.meizu.ups.push.intent.MESSAGE", context.getPackageName())) ? 0 : 1);
    }

    private void setScreenResolution(String key, int width, int height) {
        String res = width + "." + height;
        this.deviceInfoPairs.put(key, res);
    }

    private void addDeviceInfoContext(String key, String value) {
        if (!TextUtils.isEmpty((CharSequence)key) && !TextUtils.isEmpty((CharSequence)value)) {
            this.deviceInfoPairs.put(key, value);
        }
    }

    private void addAppInfoContext(String key, Object value) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        if (value instanceof String && ((String)value).isEmpty()) {
            return;
        }
        this.appInfoPairs.put(key, value);
    }

    private void addLocationInfoContext(String key, Object value) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        if (value instanceof String && ((String)value).isEmpty()) {
            return;
        }
        this.locationPairs.put(key, value);
    }

    public Map<String, String> getDeviceInfoSubject() {
        return this.deviceInfoPairs;
    }

    public Map<String, Object> getAppInfoSubject() {
        return this.appInfoPairs;
    }

    public Map<String, Object> getLocationInfoSubject() {
        return this.locationPairs;
    }

    public static class PayloadSubBuilder {
        private Context context = null;

        public PayloadSubBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public PayloadSub build() {
            return new PayloadSub(this);
        }
    }
}

