/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.analytics.secure;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Base64;
import com.meizu.cloud.pushinternal.DebugLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONObject;

public class HttpKeyMgr {
    private static final String TAG = "HttpKeyMgr";
    private static final int RESET_KEY_INTERVAL = 180000;
    private static HttpKeyMgr instance;
    private static final Object LOCK;
    private byte[] rKey;
    private byte[] aKey;
    private byte[] rKey64;
    private byte[] aKey64;
    private byte[] sKey64;
    private PublicKey publicKey;
    private final SharedPreferences spKey;
    private final SharedPreferences spPublicKey;
    private long lastResetKeysTime = 0L;
    byte[] salt;
    byte[] iv;
    private static final int KEY_SIZE = 16;
    private static final int IV_SIZE = 16;

    private HttpKeyMgr(Context context) {
        this.spKey = context.getSharedPreferences("com.x.y.1", 0);
        this.spPublicKey = context.getSharedPreferences("com.x.y.2", 0);
        int timeout = Integer.parseInt(this.spKey.getString("keyTimeout", "0"));
        long createDate = this.spKey.getLong("createDate", 0L);
        this.loadKeys();
        if (this.rKey == null || this.rKey.length == 0) {
            this.publicKey = this.loadPublicKey(context);
            if (this.publicKey != null) {
                this.generateKeys();
            } else {
                this.spKey.edit().clear().apply();
                try {
                    this.downloadPublicKey();
                    this.publicKey = this.loadPublicKey(context);
                    if (this.publicKey != null) {
                        this.generateKeys();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (this.aKey == null || this.aKey.length == 0) {
            this.publicKey = this.loadPublicKey(context);
            if (this.publicKey != null) {
                this.generateAKey();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context context) {
        if (instance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (null == instance) {
                    instance = new HttpKeyMgr(context);
                }
            }
        }
    }

    public static HttpKeyMgr get() {
        if (instance == null) {
            throw new IllegalStateException("KeyMgr is not initialised - invoke at least once with parameterised init/get");
        }
        return instance;
    }

    private PublicKey loadPublicKey(Context context) {
        this.sLogD("load publicKey from preference");
        String savePublicKey = this.spPublicKey.getString("publicKey", "");
        if (!TextUtils.isEmpty((CharSequence)savePublicKey)) {
            try {
                byte[] buffer = Base64.decode((String)savePublicKey, (int)2);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
                return keyFactory.generatePublic(keySpec);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (InvalidKeySpecException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadPublicKey() throws IOException {
        block15: {
            URL url;
            try {
                url = new URL("https://norma-external-collect.meizu.com/android/exchange/getpublickey.do");
            }
            catch (MalformedURLException e) {
                return;
            }
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDoInput(true);
            con.setUseCaches(false);
            try {
                con.setRequestMethod("GET");
            }
            catch (ProtocolException e) {
                e.printStackTrace();
            }
            con.setRequestProperty("Charset", "UTF-8");
            InputStream is = null;
            try {
                int code = con.getResponseCode();
                this.sLogD("code = " + code);
                is = con.getInputStream();
                if (null == is) break block15;
                String body = this.getStringByInputStream(is);
                this.sLogD("body = " + body);
                if (TextUtils.isEmpty((CharSequence)body)) break block15;
                try {
                    JSONObject jsonObject = new JSONObject(body);
                    int resultCode = jsonObject.getInt("code");
                    if (resultCode == 200) {
                        String value = jsonObject.getString("value");
                        SharedPreferences.Editor editor = this.spPublicKey.edit();
                        editor.putString("publicKey", value);
                        editor.apply();
                    }
                }
                catch (Exception e) {
                    this.sLogE("downloadPublicKey message error " + e.getMessage());
                }
            }
            finally {
                if (null != is) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                con.disconnect();
            }
        }
    }

    private void loadKeys() {
        this.sLogD("loadKeys");
        String saveKey = this.spKey.getString("sKey64", "");
        this.sLogD("saved sKey64: " + saveKey);
        if (!TextUtils.isEmpty((CharSequence)saveKey)) {
            this.sKey64 = saveKey.getBytes();
        }
        saveKey = this.spKey.getString("aKey64", "");
        this.sLogD("saved aKey64: " + saveKey);
        if (!TextUtils.isEmpty((CharSequence)saveKey)) {
            this.aKey64 = saveKey.getBytes();
            this.aKey = Base64.decode((byte[])this.aKey64, (int)2);
        }
        saveKey = this.spKey.getString("rKey64", "");
        this.sLogD("saved rKey64: " + saveKey);
        if (!TextUtils.isEmpty((CharSequence)saveKey)) {
            this.rKey64 = saveKey.getBytes();
            this.rKey = Base64.decode((byte[])this.rKey64, (int)2);
            this.sLogD("saved rKey: " + new String(this.rKey));
        }
    }

    private void clearKeys() {
        this.rKey = null;
        this.aKey = null;
        this.rKey64 = null;
        this.aKey64 = null;
        this.sKey64 = null;
        SharedPreferences.Editor editor = this.spKey.edit();
        editor.clear();
        editor.apply();
    }

    private void clearPublicKey() {
        SharedPreferences.Editor editor = this.spPublicKey.edit();
        editor.clear();
        editor.apply();
        this.publicKey = null;
    }

    private SecretKey deriveKeySecurely(Context context, String password, int keySizeInBytes) {
        byte[] salt = this.readFromPreferenceOrCreateRandom(context, "salt", 16);
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, 100, keySizeInBytes * 8);
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] keyBytes = keyFactory.generateSecret(keySpec).getEncoded();
            return new SecretKeySpec(keyBytes, "AES");
        }
        catch (Exception e) {
            throw new RuntimeException("Deal with exceptions properly!", e);
        }
    }

    private byte[] readFromPreferenceOrCreateRandom(Context context, String key, int size) {
        byte[] bytes;
        SharedPreferences sp = context.getSharedPreferences("com.x.y.1", 0);
        String value = sp.getString(key, "");
        if (!TextUtils.isEmpty((CharSequence)value) && (bytes = Base64.decode((String)value, (int)2)).length == size) {
            return bytes;
        }
        bytes = new byte[size];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(bytes);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(key, Base64.encodeToString((byte[])bytes, (int)2));
        editor.apply();
        return bytes;
    }

    private void generateKeys() {
        this.generateRKey();
        this.generateAKey();
    }

    private void generateRKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            SecretKey sKey = keyGenerator.generateKey();
            this.rKey = sKey.getEncoded();
            this.rKey64 = Base64.encode((byte[])this.rKey, (int)2);
            this.sLogD("***** rKey64: " + new String(this.rKey64));
            SharedPreferences.Editor editor = this.spKey.edit();
            editor.putString("rKey64", new String(this.rKey64));
            editor.apply();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateAKey() {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, this.publicKey);
            this.aKey = cipher.doFinal(this.rKey);
            this.aKey64 = Base64.encode((byte[])this.aKey, (int)2);
            this.sLogD("***** aKey64: " + new String(this.aKey64));
            SharedPreferences.Editor editor = this.spKey.edit();
            editor.putString("aKey64", new String(this.aKey64));
            editor.apply();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringByInputStream(InputStream is) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String result = null;
        try {
            int i;
            while ((i = is.read()) != -1) {
                byteArrayOutputStream.write(i);
            }
            result = byteArrayOutputStream.toString();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public byte[] encrypt(byte[] input) {
        if (this.rKey == null || this.rKey.length == 0) {
            this.sLogE("rKey null!");
            return null;
        }
        if (input == null || input.length == 0) {
            this.sLogE("input null!");
            return null;
        }
        this.sLogD(">>>>>>>>>> encrypt input >>>>>>>>>>\n" + new String(Base64.encode((byte[])input, (int)2)));
        this.sLogD("<<<<<<<<<< encrypt input <<<<<<<<<<");
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec secretKey = new SecretKeySpec(this.rKey, "AES");
            cipher.init(1, (Key)secretKey, new IvParameterSpec(this.rKey));
            byte[] output = cipher.doFinal(input);
            this.sLogD(">>>>>>>>>> encrypt output >>>>>>>>>>\n" + new String(Base64.encode((byte[])output, (int)2)));
            this.sLogD("<<<<<<<<<< encrypt output <<<<<<<<<<");
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        return null;
    }

    public byte[] decrypt(byte[] input) {
        if (this.rKey == null || this.rKey.length == 0) {
            this.sLogE("rKey null!");
            return null;
        }
        if (input == null || input.length == 0) {
            this.sLogE("input null!");
            return null;
        }
        this.sLogD(">>>>>>>>>> decrypt input >>>>>>>>>>\n" + new String(Base64.encode((byte[])input, (int)0)));
        this.sLogD("<<<<<<<<<< decrypt input <<<<<<<<<<");
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec secretKey = new SecretKeySpec(this.rKey, "AES");
            cipher.init(2, (Key)secretKey, new IvParameterSpec(this.rKey));
            byte[] output = cipher.doFinal(input);
            this.sLogD(">>>>>>>>>> decrypt output >>>>>>>>>>\n" + new String(Base64.encode((byte[])output, (int)0)));
            this.sLogD("<<<<<<<<<< decrypt output <<<<<<<<<<");
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void saveSKey(String sKey) {
        this.sKey64 = sKey.getBytes();
        SharedPreferences.Editor editor = this.spKey.edit();
        editor.putString("sKey64", new String(this.sKey64));
        editor.apply();
    }

    public void saveKeyTimeout(String keyTimeout) {
        SharedPreferences.Editor editor = this.spKey.edit();
        editor.putString("keyTimeout", keyTimeout);
        editor.putLong("createDate", System.currentTimeMillis());
        editor.apply();
    }

    public synchronized void reInitKeys(Context context) {
        this.sLogD("reInitKeys");
        if (this.lastResetKeysTime == 0L || System.currentTimeMillis() - this.lastResetKeysTime > 180000L) {
            this.clearPublicKey();
            this.clearKeys();
            this.lastResetKeysTime = System.currentTimeMillis();
            try {
                this.downloadPublicKey();
                this.publicKey = this.loadPublicKey(context);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.publicKey != null) {
                this.generateKeys();
            }
        }
    }

    public byte[] getAKey64() {
        return this.aKey64;
    }

    public byte[] getsKey64() {
        return this.sKey64;
    }

    private void sLogD(String msg) {
        DebugLogger.d(TAG, msg);
    }

    private void sLogE(String msg) {
        DebugLogger.e(TAG, msg);
    }

    static {
        LOCK = new Object();
    }
}

