/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.analytics.secure;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.analytics.secure.HttpKeyMgr;
import com.meizu.cloud.pushsdk.analytics.secure.NetResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpSecureRequester {
    private static final String TAG = HttpSecureRequester.class.getSimpleName();
    private static final Object LOCK = new Object();
    private static final String APPLICATION_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final int ATTACH_KEY_HEADER_MAP_SIZE = 2;
    private static HttpSecureRequester sInstance;

    private HttpSecureRequester(Context context) {
        try {
            System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HttpKeyMgr.init(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpSecureRequester getInstance(Context context) {
        if (sInstance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = new HttpSecureRequester(context);
                }
            }
        }
        return sInstance;
    }

    public NetResponse stringPartRequest(String method, Map<String, String> headers, String content) {
        headers = this.attachKeyHeader(headers);
        NetResponse response = null;
        try {
            response = this.realStringPartRequest(method, headers, content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NetResponse realStringPartRequest(String method, Map<String, String> headers, String data) throws Exception {
        URL url;
        NetResponse netResponse = null;
        if (data == null) return netResponse;
        byte[] encrypted = HttpKeyMgr.get().encrypt(data.getBytes());
        String encryptedBaseData = null;
        if (encrypted != null) {
            encryptedBaseData = new String(Base64.encode((byte[])encrypted, (int)2));
        }
        try {
            url = new URL("https://norma-external-collect.meizu.com/push/android/external/add.do");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod(method);
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setConnectTimeout(30000);
        con.setReadTimeout(30000);
        con.setRequestProperty("Connection", "keep-alive");
        con.setRequestProperty("Charset", "UTF-8");
        con.setRequestProperty("Content-Type", APPLICATION_CONTENT_TYPE);
        con.setRequestProperty("Content-Encoding", "gzip");
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                con.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        InputStream is = null;
        try {
            if (encryptedBaseData != null) {
                this.writeBody(con, encryptedBaseData.getBytes());
            }
            int code = con.getResponseCode();
            DebugLogger.d(TAG, "code = " + code);
            this.getSKey(con);
            this.getKeyTimeout(con);
            byte[] body = null;
            is = con.getInputStream();
            if (null != is && (body = this.getByteArrayByInputStream(is)) != null) {
                String bodyStr = new String(body);
                DebugLogger.d(TAG, "body = " + bodyStr);
                try {
                    JSONObject object = new JSONObject(bodyStr);
                    if (object.getInt("code") != 198003) {
                        // empty if block
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (body != null) {
                netResponse = new NetResponse(code, new String(body));
                return netResponse;
            }
            netResponse = new NetResponse(code, null);
            return netResponse;
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "realStringPartRequest error " + e.getMessage());
            return netResponse;
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            con.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBody(HttpURLConnection connection, byte[] body) throws IOException {
        GZIPOutputStream os = null;
        try {
            os = new GZIPOutputStream(connection.getOutputStream());
            ((OutputStream)os).write(body);
            ((OutputStream)os).flush();
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Map<String, String> attachKeyHeader(Map<String, String> headers) {
        byte[] sKey64;
        if (headers == null) {
            headers = new HashMap<String, String>(2);
        }
        if ((sKey64 = HttpKeyMgr.get().getsKey64()) != null && sKey64.length > 0) {
            String sKey = new String(sKey64);
            DebugLogger.d(TAG, "attach x_s_key: " + sKey);
            headers.put("X-S-Key", sKey);
        } else {
            byte[] aKey64 = HttpKeyMgr.get().getAKey64();
            if (aKey64 != null && aKey64.length > 0) {
                String aKey = new String(HttpKeyMgr.get().getAKey64());
                DebugLogger.d(TAG, "attach x_a_key: " + aKey);
                headers.put("X-A-Key", aKey);
            }
        }
        return headers;
    }

    private void getSKey(URLConnection con) {
        try {
            String sKey = con.getHeaderField("X-S-Key");
            DebugLogger.d(TAG, "get x_s_key = " + sKey);
            if (!TextUtils.isEmpty((CharSequence)sKey)) {
                HttpKeyMgr.get().saveSKey(sKey);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void getKeyTimeout(URLConnection con) {
        try {
            String keyTimeout = con.getHeaderField("Key-Timeout");
            DebugLogger.d(TAG, "get keyTimeout = " + keyTimeout);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getByteArrayByInputStream(InputStream is) throws IOException {
        byte[] result;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            int i;
            while ((i = is.read()) != -1) {
                stream.write(i);
            }
            result = stream.toByteArray();
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }
}

