/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.base;

import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import com.meizu.cloud.pushsdk.base.EncryptionWriter;
import com.meizu.cloud.pushsdk.base.ICacheLog;
import com.meizu.cloud.pushsdk.base.ThreadFactoryBuilder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class DefaultLog
implements ICacheLog {
    private static final int CORE_POOL_SIZE = 1;
    private static final int MAXIMUM_POOL_SIZE = 1;
    private static final long KEEP_ALIVE_TIME = 30L;
    private final SimpleDateFormat mDateFormat = new SimpleDateFormat("MM-dd HH:mm:ss");
    private final List<LogInfo> mCachedList = Collections.synchronizedList(new ArrayList());
    private final Handler mDelayHandler = new Handler(Looper.getMainLooper());
    private long mCacheDuration = 60L;
    private int mCacheCounter = 10;
    private final EncryptionWriter mWriter;
    private String mPath = Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/data/pushSdk/defaultLog";
    private final String mPid;
    private boolean mDebugMode = false;
    private ThreadPoolExecutor mThreadPool;

    public DefaultLog() {
        this.mWriter = new EncryptionWriter();
        this.mPid = String.valueOf(Process.myPid());
        this.mThreadPool = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("log-pool-%d").build());
        this.mThreadPool.allowCoreThreadTimeOut(true);
    }

    private void startDelayTimer() {
        if (this.mCachedList.size() == 0) {
            this.mDelayHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    DefaultLog.this.flush(true);
                }
            }, this.mCacheDuration * 1000L);
        }
    }

    private void checkLogCount() {
        if (this.mCachedList.size() == this.mCacheCounter) {
            this.flush(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void d(String tag, String msg) {
        if (this.mDebugMode) {
            Log.d((String)tag, (String)msg);
        }
        List<LogInfo> list = this.mCachedList;
        synchronized (list) {
            this.startDelayTimer();
            this.addLogInfo(new LogInfo("D", tag, msg));
            this.checkLogCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void i(String tag, String msg) {
        if (this.mDebugMode) {
            Log.i((String)tag, (String)msg);
        }
        List<LogInfo> list = this.mCachedList;
        synchronized (list) {
            this.startDelayTimer();
            this.addLogInfo(new LogInfo("I", tag, msg));
            this.checkLogCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void w(String tag, String msg) {
        if (this.mDebugMode) {
            Log.w((String)tag, (String)msg);
        }
        List<LogInfo> list = this.mCachedList;
        synchronized (list) {
            this.startDelayTimer();
            this.addLogInfo(new LogInfo("W", tag, msg));
            this.checkLogCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void e(String tag, String msg) {
        if (this.mDebugMode) {
            Log.e((String)tag, (String)msg);
        }
        List<LogInfo> list = this.mCachedList;
        synchronized (list) {
            this.startDelayTimer();
            this.addLogInfo(new LogInfo("E", tag, msg));
            this.checkLogCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void e(String tag, String msg, Throwable tr) {
        if (this.mDebugMode) {
            Log.e((String)tag, (String)msg, (Throwable)tr);
        }
        List<LogInfo> list = this.mCachedList;
        synchronized (list) {
            this.startDelayTimer();
            this.addLogInfo(new LogInfo("E", tag, msg + "\n" + Log.getStackTraceString((Throwable)tr)));
            this.checkLogCount();
        }
    }

    @Override
    public void setCacheDuration(long seconds) {
        this.mCacheDuration = seconds;
    }

    @Override
    public void setCacheCount(int counter) {
        this.mCacheCounter = counter;
    }

    @Override
    public void setFilePath(String path) {
        this.mPath = path;
    }

    @Override
    public void flush(boolean async) {
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList tmp;
                List list = DefaultLog.this.mCachedList;
                synchronized (list) {
                    DefaultLog.this.mDelayHandler.removeCallbacksAndMessages(null);
                    tmp = new ArrayList(DefaultLog.this.mCachedList);
                    DefaultLog.this.mCachedList.clear();
                }
                try {
                    DefaultLog.this.mWriter.open(DefaultLog.this.mPath);
                    for (LogInfo logInfo : tmp) {
                        DefaultLog.this.mWriter.write(logInfo.header, logInfo.tag, logInfo.msg);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        DefaultLog.this.mWriter.close();
                    }
                    catch (Exception exception) {}
                }
            }
        };
        if (async && this.mThreadPool != null) {
            this.mThreadPool.execute(task);
        } else {
            task.run();
        }
    }

    @Override
    public void setDebugMode(boolean debug) {
        this.mDebugMode = debug;
    }

    @Override
    public boolean isDebugMode() {
        return this.mDebugMode;
    }

    private void addLogInfo(LogInfo logInfo) {
        try {
            this.mCachedList.add(logInfo);
        }
        catch (Exception e) {
            Log.e((String)"Logger", (String)("add logInfo error " + e.getMessage()));
        }
    }

    class LogInfo {
        final String header;
        final String tag;
        final String msg;

        public LogInfo(String level, String tag, String msg) {
            this.header = DefaultLog.this.mDateFormat.format(new Date()) + " " + DefaultLog.this.mPid + "-" + Thread.currentThread().getId() + " " + level + "/";
            this.tag = tag;
            this.msg = msg;
        }
    }
}

