/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.base;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.base.SystemProperties;
import com.meizu.cloud.pushsdk.base.reflect.ReflectClass;
import com.meizu.cloud.pushsdk.base.reflect.ReflectResult;

public class DeviceUtils {
    private static final String TAG = "DeviceUtils";
    private static final String CLASS_NAME = "android.telephony.MzTelephonyManager";
    private static final String METHOD_NAME = "getDeviceId";
    private static String sDeviceId = "";

    public static boolean isPhone() {
        String value = SystemProperties.get("ro.target.product");
        if (!TextUtils.isEmpty((CharSequence)value)) {
            DebugLogger.i(TAG, "current product is " + value);
            return false;
        }
        DebugLogger.i(TAG, "current product is phone");
        return true;
    }

    public static String getDeviceType() {
        String deviceType = SystemProperties.get("ro.target.product");
        if (!TextUtils.isEmpty((CharSequence)deviceType)) {
            DebugLogger.i(TAG, "current product is " + deviceType);
        }
        return deviceType;
    }

    public static String getDeviceId(Context context) {
        if (!TextUtils.isEmpty((CharSequence)sDeviceId)) {
            return sDeviceId;
        }
        sDeviceId = !DeviceUtils.isPhone() ? DeviceUtils.getNonPhoneDeviceId(context) : DeviceUtils.getPhoneDeviceId(context);
        return sDeviceId;
    }

    private static String getNonPhoneDeviceId(Context context) {
        StringBuilder nonce = new StringBuilder();
        String sn = Build.SERIAL;
        DebugLogger.i(TAG, "device serial " + sn);
        if (TextUtils.isEmpty((CharSequence)sn)) {
            return null;
        }
        nonce.append(sn);
        String mac = DeviceUtils.getMacAddress(context);
        DebugLogger.e(TAG, "mac address " + mac);
        if (TextUtils.isEmpty((CharSequence)mac)) {
            return null;
        }
        mac = mac.replace(":", "");
        mac = mac.toUpperCase();
        nonce.append(mac);
        return nonce.toString();
    }

    @SuppressLint(value={"MissingPermission", "HardwareIds"})
    public static String getPhoneDeviceId(Context context) {
        String deviceId = null;
        try {
            ReflectResult result = ReflectClass.forName(CLASS_NAME).method(METHOD_NAME, new Class[0]).invokeStatic(new Object[0]);
            if (result.ok && !TextUtils.isEmpty((CharSequence)((CharSequence)result.value))) {
                deviceId = (String)result.value;
            } else {
                TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                if (tm != null) {
                    deviceId = tm.getDeviceId();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deviceId;
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getMacAddress(Context context) {
        String address = null;
        return address;
    }
}

