/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.base;

import java.nio.charset.Charset;

class EncryptBase64 {
    private static final char[] BASE64_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char LAST2BYTE = (char)Integer.parseInt("00000011", 2);
    private static final char LAST4BYTE = (char)Integer.parseInt("00001111", 2);
    private static final char LAST6BYTE = (char)Integer.parseInt("00111111", 2);
    private final String mPrivateKey;
    private char[] mBase64Table;
    private int offset = 0;

    public EncryptBase64(String key) {
        this.mPrivateKey = key;
        this.initPrivateTable();
    }

    public String encode(byte[] contents) {
        if (contents == null || contents.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder((contents.length + 2) / 3 * 4);
        int i = 0;
        int len = contents.length;
        while (i < len) {
            int b1 = contents[i++] & 0xFF;
            if (i == len) {
                sb.append(this.mBase64Table[b1 >>> 2]);
                sb.append(this.mBase64Table[(b1 & LAST2BYTE) << 4]);
                sb.append("==");
                break;
            }
            int b2 = contents[i++] & 0xFF;
            if (i == len) {
                sb.append(this.mBase64Table[b1 >>> 2]);
                sb.append(this.mBase64Table[(b1 & LAST2BYTE) << 4 | b2 >>> 4]);
                sb.append(this.mBase64Table[(b2 & LAST4BYTE) << 2]);
                sb.append("=");
                break;
            }
            int b3 = contents[i++] & 0xFF;
            sb.append(this.mBase64Table[b1 >>> 2]);
            sb.append(this.mBase64Table[(b1 & LAST2BYTE) << 4 | b2 >>> 4]);
            sb.append(this.mBase64Table[(b2 & LAST4BYTE) << 2 | b3 >>> 6]);
            sb.append(this.mBase64Table[b3 & LAST6BYTE]);
        }
        return sb.toString();
    }

    public byte[] decode(byte[] data, int len) {
        StringBuilder sb = new StringBuilder(len * 3 / 4);
        int i = 0;
        int[] b = new int[4];
        while (i < len) {
            for (int j = 0; j < 4; ++j) {
                b[j] = this.base64To256(data[i++]);
            }
            sb.append((char)(b[0] << 2 | b[1] >>> 4));
            if (b[2] != 64) {
                sb.append((char)((b[1] & LAST4BYTE) << 4 | b[2] >>> 2));
            }
            if (b[3] == 64) continue;
            sb.append((char)((b[2] & LAST2BYTE) << 6 | b[3]));
        }
        return sb.toString().getBytes(Charset.forName("ISO8859-1"));
    }

    private void initPrivateTable() {
        char[] privateBase64Table = new char[BASE64_TABLE.length];
        this.offset = this.mPrivateKey.charAt(0) % 13;
        for (int i = 0; i < BASE64_TABLE.length; ++i) {
            privateBase64Table[i] = BASE64_TABLE[(i + this.offset) % BASE64_TABLE.length];
        }
        this.mBase64Table = privateBase64Table;
    }

    private int base64To256(byte base64) {
        if (base64 >= 65 && base64 <= 90) {
            return (base64 - 65 + (BASE64_TABLE.length - this.offset)) % BASE64_TABLE.length;
        }
        if (base64 >= 97 && base64 <= 122) {
            return (base64 - 97 + 26 + (BASE64_TABLE.length - this.offset)) % BASE64_TABLE.length;
        }
        if (base64 >= 48 && base64 <= 57) {
            return (base64 - 48 + 52 + (BASE64_TABLE.length - this.offset)) % BASE64_TABLE.length;
        }
        if (base64 == 43) {
            return (62 + (BASE64_TABLE.length - this.offset)) % BASE64_TABLE.length;
        }
        if (base64 == 47) {
            return (63 + (BASE64_TABLE.length - this.offset)) % BASE64_TABLE.length;
        }
        return 64;
    }
}

