/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.base;

import android.util.Log;
import com.meizu.cloud.pushsdk.base.EncryptBase64;
import com.meizu.cloud.pushsdk.base.ILogWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;

class EncryptionWriter
implements ILogWriter {
    private static final String TAG = "EncryptionWriter";
    private static final int FILE_COUNT = 7;
    private static final String FILE_SUFFIX_NAME = ".log.txt";
    private final SimpleDateFormat mDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final EncryptBase64 mEncryptBase64 = new EncryptBase64("lo");
    private BufferedWriter mWriter;

    void checkFileCount(File dir) {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(EncryptionWriter.FILE_SUFFIX_NAME);
            }
        });
        if (files != null && files.length > 7) {
            Arrays.sort(files, new ComparatorByLastModified());
            for (int i = 7; i < files.length; ++i) {
                files[i].delete();
            }
        }
    }

    @Override
    public void open(String path) throws IOException {
        File dir = new File(path);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("create " + path + " dir failed!!!");
        }
        String name = this.mDateFormat.format(new Date());
        File file = new File(path, name + FILE_SUFFIX_NAME);
        if (!file.exists()) {
            if (!file.createNewFile()) {
                Log.e((String)TAG, (String)("create new file " + name + " failed !!!"));
            } else {
                this.checkFileCount(dir);
            }
        }
        this.mWriter = new BufferedWriter(new FileWriter(file, true));
    }

    @Override
    public void write(String header, String tag, String msg) throws IOException {
        if (this.mWriter != null) {
            String buffer = header + tag + " " + msg;
            this.mWriter.write(this.mEncryptBase64.encode(buffer.getBytes()));
            this.mWriter.write("\r\n");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mWriter != null) {
            this.mWriter.flush();
            this.mWriter.close();
            this.mWriter = null;
        }
    }

    class ComparatorByLastModified
    implements Comparator<File> {
        ComparatorByLastModified() {
        }

        @Override
        public int compare(File f1, File f2) {
            long diff = f1.lastModified() - f2.lastModified();
            if (diff > 0L) {
                return -1;
            }
            if (diff == 0L) {
                return 0;
            }
            return 1;
        }
    }
}

