/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.base.alarm;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import com.meizu.cloud.pushinternal.DebugLogger;

public class AlarmUtils {
    private static final String TAG = "AlarmUtils";
    private static final String ACTION = "alarm.util";
    private AlarmManager mAlarmManager;
    private Context mContext;
    private Runnable mTarget;
    private long mDelayMillis;
    private int mType;
    private AlarmReceiver mAlarmReceiver;
    private PendingIntent mPendingIntent;
    private String mKeyword;
    private boolean mComplete;

    public AlarmUtils(Context context, Runnable target, long delayMillis) {
        this(context, target, delayMillis, true);
    }

    public AlarmUtils(Context context, Runnable target, long delayMillis, boolean wakeup) {
        this.mContext = context.getApplicationContext();
        this.mTarget = target;
        this.mDelayMillis = delayMillis;
        this.mType = wakeup ? 0 : 1;
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        this.mComplete = true;
    }

    public boolean start() {
        if (!this.mComplete) {
            DebugLogger.e(TAG, "last task not completed");
            return false;
        }
        this.mComplete = false;
        this.mAlarmReceiver = new AlarmReceiver();
        this.mContext.registerReceiver((BroadcastReceiver)this.mAlarmReceiver, new IntentFilter(ACTION));
        this.mKeyword = String.valueOf(System.currentTimeMillis());
        Intent intent = new Intent(ACTION);
        this.mPendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0x40000000);
        if (Build.VERSION.SDK_INT >= 23) {
            this.mAlarmManager.setExactAndAllowWhileIdle(this.mType, System.currentTimeMillis() + this.mDelayMillis, this.mPendingIntent);
        } else if (Build.VERSION.SDK_INT >= 19) {
            this.mAlarmManager.setExact(this.mType, System.currentTimeMillis() + this.mDelayMillis, this.mPendingIntent);
        } else {
            this.mAlarmManager.set(this.mType, System.currentTimeMillis() + this.mDelayMillis, this.mPendingIntent);
        }
        DebugLogger.i(TAG, "start delayed task, keyword: " + this.mKeyword);
        return true;
    }

    public void cancel() {
        if (this.mAlarmManager != null && this.mPendingIntent != null && !this.mComplete) {
            DebugLogger.i(TAG, "cancel  delayed task, keyword: " + this.mKeyword);
            this.mAlarmManager.cancel(this.mPendingIntent);
        }
        this.clean();
    }

    private void clean() {
        try {
            if (this.mAlarmReceiver != null) {
                this.mContext.unregisterReceiver((BroadcastReceiver)this.mAlarmReceiver);
                this.mAlarmReceiver = null;
            }
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "clean error, " + e.getMessage());
        }
    }

    private class AlarmReceiver
    extends BroadcastReceiver {
        private AlarmReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent == null || !intent.getAction().equals(AlarmUtils.ACTION)) {
                return;
            }
            DebugLogger.i(AlarmUtils.TAG, "on receive delayed task, keyword: " + AlarmUtils.this.mKeyword);
            AlarmUtils.this.mComplete = true;
            AlarmUtils.this.clean();
            AlarmUtils.this.mTarget.run();
        }
    }
}

