/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.base.reflect;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.base.reflect.ReflectClass;
import com.meizu.cloud.pushsdk.base.reflect.ReflectResult;
import java.lang.reflect.Constructor;

public class ReflectConstructor {
    private static final String TAG = "ReflectConstructor";
    private final ReflectClass mReflectClass;
    private final Class<?>[] mTypes;

    ReflectConstructor(ReflectClass reflectClass, Class<?> ... types) {
        this.mReflectClass = reflectClass;
        this.mTypes = types;
    }

    public <T> ReflectResult<T> newInstance(Object ... args) {
        ReflectResult result = new ReflectResult();
        try {
            Constructor<?> constructor = this.mReflectClass.getRealClass().getDeclaredConstructor(this.mTypes);
            constructor.setAccessible(true);
            result.value = constructor.newInstance(args);
            result.ok = true;
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "newInstance", e);
        }
        return result;
    }
}

