/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.base.reflect;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.base.reflect.ReflectClass;
import com.meizu.cloud.pushsdk.base.reflect.ReflectResult;
import java.lang.reflect.Field;

public class ReflectField {
    private static final String TAG = "ReflectField";
    private final ReflectClass mReflectClass;
    private final String mFieldName;

    ReflectField(ReflectClass reflectClass, String fieldName) {
        this.mReflectClass = reflectClass;
        this.mFieldName = fieldName;
    }

    private Field getField() throws ClassNotFoundException, NoSuchFieldException {
        Field field = this.mReflectClass.getRealClass().getDeclaredField(this.mFieldName);
        field.setAccessible(true);
        return field;
    }

    public <T> ReflectResult<T> set(Object receiver, T value) {
        ReflectResult result = new ReflectResult();
        try {
            Field field = this.getField();
            field.set(receiver, value);
            result.value = value;
            result.ok = true;
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "set", e);
        }
        return result;
    }

    public <T> ReflectResult<T> setStatic(T value) {
        try {
            return this.set(this.mReflectClass.getRealClass(), value);
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "setStatic", e);
            return new ReflectResult();
        }
    }

    public <T> ReflectResult<T> get(Object receiver) {
        ReflectResult result = new ReflectResult();
        try {
            Field field = this.getField();
            result.value = field.get(receiver);
            result.ok = true;
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "get", e);
        }
        return result;
    }

    public <T> ReflectResult<T> getStatic() {
        try {
            return this.get(this.mReflectClass.getRealClass());
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "getStatic", e);
            return new ReflectResult();
        }
    }
}

