/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.base.reflect;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.base.reflect.ReflectClass;
import com.meizu.cloud.pushsdk.base.reflect.ReflectResult;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;

public class ReflectMethod {
    private static final String TAG = "ReflectMethod";
    private static final HashMap<String, Method> CACHED_METHODS = new HashMap();
    private final ReflectClass mReflectClass;
    private final String mMethodName;
    private Class<?>[] mTypes;

    ReflectMethod(ReflectClass reflectClass, String name, Class<?> ... types) {
        this.mReflectClass = reflectClass;
        this.mMethodName = name;
        this.mTypes = types;
    }

    private boolean match(Class<?>[] declaredTypes, Class<?>[] actualTypes) {
        if (declaredTypes.length == actualTypes.length) {
            for (int i = 0; i < actualTypes.length; ++i) {
                if (actualTypes[i] == NULL.class || this.wrapper(declaredTypes[i]).isAssignableFrom(this.wrapper(actualTypes[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isSimilarSignature(Method possiblyMatchingMethod, String desiredMethodName, Class<?>[] desiredParamTypes) {
        return possiblyMatchingMethod.getName().equals(desiredMethodName) && this.match(possiblyMatchingMethod.getParameterTypes(), desiredParamTypes);
    }

    private Method similarMethod() throws NoSuchMethodException, ClassNotFoundException {
        Class<?> clz = this.mReflectClass.getRealClass();
        for (Method method : clz.getMethods()) {
            if (!this.isSimilarSignature(method, this.mMethodName, this.mTypes)) continue;
            return method;
        }
        for (Method method : clz.getDeclaredMethods()) {
            if (!this.isSimilarSignature(method, this.mMethodName, this.mTypes)) continue;
            return method;
        }
        throw new NoSuchMethodException("No similar method " + this.mMethodName + " with params " + Arrays.toString(this.mTypes) + " could be found on type " + clz);
    }

    private String getKey() throws ClassNotFoundException {
        StringBuilder buffer = new StringBuilder(this.mReflectClass.getRealClass().getName());
        buffer.append(this.mMethodName);
        for (Class<?> type : this.mTypes) {
            buffer.append(type.getName());
        }
        return buffer.toString();
    }

    public <T> ReflectResult<T> invoke(Object receiver, Object ... args) {
        ReflectResult result = new ReflectResult();
        try {
            String key = this.getKey();
            Method method = CACHED_METHODS.get(key);
            if (method == null) {
                if (this.mTypes.length == args.length) {
                    method = this.mReflectClass.getRealClass().getMethod(this.mMethodName, this.mTypes);
                } else {
                    if (args.length > 0) {
                        this.mTypes = new Class[args.length];
                        for (int i = 0; i < args.length; ++i) {
                            this.mTypes[i] = args[i].getClass();
                        }
                    }
                    method = this.similarMethod();
                }
                CACHED_METHODS.put(key, method);
            }
            method.setAccessible(true);
            result.value = method.invoke(receiver, args);
            result.ok = true;
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "invoke", e);
        }
        return result;
    }

    public <T> ReflectResult<T> invokeStatic(Object ... args) {
        try {
            return this.invoke(this.mReflectClass.getRealClass(), args);
        }
        catch (ClassNotFoundException e) {
            return new ReflectResult();
        }
    }

    private Class<?> wrapper(Class<?> type) {
        if (type == null) {
            return null;
        }
        if (type.isPrimitive()) {
            if (Boolean.TYPE == type) {
                return Boolean.class;
            }
            if (Integer.TYPE == type) {
                return Integer.class;
            }
            if (Long.TYPE == type) {
                return Long.class;
            }
            if (Short.TYPE == type) {
                return Short.class;
            }
            if (Byte.TYPE == type) {
                return Byte.class;
            }
            if (Double.TYPE == type) {
                return Double.class;
            }
            if (Float.TYPE == type) {
                return Float.class;
            }
            if (Character.TYPE == type) {
                return Character.class;
            }
            if (Void.TYPE == type) {
                return Void.class;
            }
        }
        return type;
    }

    private class NULL {
        private NULL() {
        }
    }
}

