/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.base.thread;

import android.support.annotation.NonNull;
import com.meizu.cloud.pushsdk.base.thread.ThreadFactoryBuilder;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultExecutorUtils
implements Executor {
    private static final int CORE_POOL_SIZE;
    private static final int MAXIMUM_POOL_SIZE;
    private static final long KEEP_ALIVE_TIME = 0L;
    private final ThreadPoolExecutor mDefaultThreadPool = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("default-pool-%d").build());

    private DefaultExecutorUtils() {
    }

    public static DefaultExecutorUtils getInstance() {
        return InnerSingleton.sInstance;
    }

    @Override
    public void execute(@NonNull Runnable command) {
        this.mDefaultThreadPool.execute(command);
    }

    static {
        MAXIMUM_POOL_SIZE = CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    }

    private static class InnerSingleton {
        private static DefaultExecutorUtils sInstance = new DefaultExecutorUtils();

        private InnerSingleton() {
        }
    }
}

