/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler;

import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageSerialize {
    private static final String TAG = "MessageSerialize";

    public static String messageV3ToString(MessageV3 messageV3) {
        DebugLogger.i(TAG, "message serialize messageV3ToString start, messageV3=" + messageV3);
        try {
            JSONObject jsonMessageV3 = new JSONObject();
            if (!TextUtils.isEmpty((CharSequence)messageV3.getTaskId())) {
                jsonMessageV3.put("task_id", (Object)messageV3.getTaskId());
            }
            if (!TextUtils.isEmpty((CharSequence)messageV3.getSeqId())) {
                jsonMessageV3.put("seq_id", (Object)messageV3.getSeqId());
            }
            if (!TextUtils.isEmpty((CharSequence)messageV3.getDeviceId())) {
                jsonMessageV3.put("device_id", (Object)messageV3.getDeviceId());
            }
            if (!TextUtils.isEmpty((CharSequence)messageV3.getTitle())) {
                jsonMessageV3.put("title", (Object)messageV3.getTitle());
            }
            if (!TextUtils.isEmpty((CharSequence)messageV3.getContent())) {
                jsonMessageV3.put("content", (Object)messageV3.getContent());
            }
            if (!TextUtils.isEmpty((CharSequence)messageV3.getPackageName())) {
                jsonMessageV3.put("package_name", (Object)messageV3.getPackageName());
            }
            jsonMessageV3.put("clickType", messageV3.getClickType());
            jsonMessageV3.put("isDiscard", messageV3.isDiscard());
            if (!TextUtils.isEmpty((CharSequence)messageV3.getActivity())) {
                jsonMessageV3.put("activity", (Object)messageV3.getActivity());
            }
            if (!TextUtils.isEmpty((CharSequence)messageV3.getWebUrl())) {
                jsonMessageV3.put("url", (Object)messageV3.getWebUrl());
            }
            if (!TextUtils.isEmpty((CharSequence)messageV3.getUriPackageName())) {
                jsonMessageV3.put("pk", (Object)messageV3.getUriPackageName());
            }
            if (!TextUtils.isEmpty((CharSequence)messageV3.getPushTimestamp())) {
                jsonMessageV3.put("push_timestamp", (Object)messageV3.getPushTimestamp());
            }
            if (!TextUtils.isEmpty((CharSequence)messageV3.getUploadDataPackageName())) {
                jsonMessageV3.put("upload_data_package_name", (Object)messageV3.getUploadDataPackageName());
            }
            if (messageV3.getParamsMap() != null && messageV3.getParamsMap().size() > 0) {
                jsonMessageV3.put("parameters", (Object)new JSONObject(messageV3.getParamsMap()));
            }
            if (!TextUtils.isEmpty((CharSequence)messageV3.getThroughMessage())) {
                jsonMessageV3.put("through_message", (Object)messageV3.getThroughMessage());
            }
            if (!TextUtils.isEmpty((CharSequence)messageV3.getNotificationMessage())) {
                jsonMessageV3.put("notification_message", (Object)messageV3.getNotificationMessage());
            }
            String msgText = jsonMessageV3.toString();
            DebugLogger.i(TAG, "message serialize messageV3ToString success, msgText=" + msgText);
            return msgText;
        }
        catch (JSONException e) {
            DebugLogger.e(TAG, "message serialize messageV3ToString error, " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static MessageV3 stringToMessageV3(String msgText) {
        DebugLogger.i(TAG, "message serialize stringToMessageV3 start, msgText=" + msgText);
        try {
            MessageV3 messageV3 = new MessageV3();
            JSONObject jsonMessageV3 = new JSONObject(msgText);
            if (!jsonMessageV3.isNull("task_id")) {
                messageV3.setTaskId(jsonMessageV3.getString("task_id"));
            }
            if (!jsonMessageV3.isNull("seq_id")) {
                messageV3.setSeqId(jsonMessageV3.getString("seq_id"));
            }
            if (!jsonMessageV3.isNull("device_id")) {
                messageV3.setDeviceId(jsonMessageV3.getString("device_id"));
            }
            if (!jsonMessageV3.isNull("title")) {
                messageV3.setTitle(jsonMessageV3.getString("title"));
            }
            if (!jsonMessageV3.isNull("content")) {
                messageV3.setContent(jsonMessageV3.getString("content"));
            }
            if (!jsonMessageV3.isNull("package_name")) {
                messageV3.setPackageName(jsonMessageV3.getString("package_name"));
            }
            if (!jsonMessageV3.isNull("clickType")) {
                messageV3.setClickType(jsonMessageV3.getInt("clickType"));
            }
            if (!jsonMessageV3.isNull("isDiscard")) {
                messageV3.setIsDiscard(jsonMessageV3.getBoolean("isDiscard"));
            }
            if (!jsonMessageV3.isNull("activity")) {
                messageV3.setActivity(jsonMessageV3.getString("activity"));
            }
            if (!jsonMessageV3.isNull("url")) {
                messageV3.setWebUrl(jsonMessageV3.getString("url"));
            }
            if (!jsonMessageV3.isNull("pk")) {
                messageV3.setUriPackageName(jsonMessageV3.getString("pk"));
            }
            if (!jsonMessageV3.isNull("push_timestamp")) {
                messageV3.setPushTimestamp(jsonMessageV3.getString("push_timestamp"));
            }
            if (!jsonMessageV3.isNull("upload_data_package_name")) {
                messageV3.setUploadDataPackageName(jsonMessageV3.getString("upload_data_package_name"));
            }
            if (!jsonMessageV3.isNull("parameters")) {
                JSONObject jsonObject = jsonMessageV3.getJSONObject("parameters");
                HashMap<String, String> paramsMap = new HashMap<String, String>(jsonObject.length());
                Iterator extraIterator = jsonObject.keys();
                while (extraIterator.hasNext()) {
                    String key = (String)extraIterator.next();
                    String value = jsonObject.getString(key);
                    paramsMap.put(key, value);
                }
                messageV3.setParamsMap(paramsMap);
            }
            if (!jsonMessageV3.isNull("through_message")) {
                messageV3.setThroughMessage(jsonMessageV3.getString("through_message"));
            }
            if (!jsonMessageV3.isNull("notification_message")) {
                messageV3.setNotificationMessage(jsonMessageV3.getString("notification_message"));
            }
            DebugLogger.i(TAG, "message serialize stringToMessageV3 success, messageV3=" + messageV3);
            return messageV3;
        }
        catch (JSONException e) {
            DebugLogger.e(TAG, "message serialize stringToMessageV3 error\uff0c " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

