/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.notification.MPushMessage;
import com.meizu.cloud.pushsdk.notification.model.AdvanceSetting;
import com.meizu.cloud.pushsdk.notification.model.AdvanceSettingEx;
import com.meizu.cloud.pushsdk.notification.model.AdvertisementOption;
import com.meizu.cloud.pushsdk.notification.model.AppIconSetting;
import com.meizu.cloud.pushsdk.notification.model.BrightRemindSetting;
import com.meizu.cloud.pushsdk.notification.model.NotificationStyle;
import com.meizu.cloud.pushsdk.notification.model.TimeDisplaySetting;
import com.meizu.cloud.pushsdk.pushtracer.utils.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageV3
implements Parcelable {
    private static final String TAG = "Message_V3";
    private String taskId;
    private String seqId;
    private String deviceId;
    private String title;
    private String content;
    private String packageName;
    private int clickType;
    private boolean isDiscard;
    private String activity;
    private String webUrl;
    private String uriPackageName;
    private String pushTimestamp;
    private String uploadDataPackageName;
    private Map<String, String> paramsMap = new HashMap<String, String>();
    private String throughMessage;
    private String notificationMessage;
    private AdvanceSetting mAdvanceSetting;
    private AppIconSetting mAppIconSetting;
    private NotificationStyle mNotificationStyle;
    private TimeDisplaySetting mTimeDisplaySetting;
    private boolean whiteList;
    private long delayedReportMillis;
    private BrightRemindSetting mBrightRemindSetting;
    private AdvanceSettingEx mAdvanceSettingEx;
    private AdvertisementOption mAdvertisementOption;
    public static final Parcelable.Creator<MessageV3> CREATOR = new Parcelable.Creator<MessageV3>(){

        public MessageV3 createFromParcel(Parcel in) {
            return new MessageV3(in);
        }

        public MessageV3[] newArray(int size) {
            return new MessageV3[size];
        }
    };

    public MessageV3(Parcel in) {
        this.taskId = in.readString();
        this.seqId = in.readString();
        this.deviceId = in.readString();
        this.title = in.readString();
        this.content = in.readString();
        this.packageName = in.readString();
        this.clickType = in.readInt();
        this.isDiscard = in.readByte() != 0;
        this.activity = in.readString();
        this.webUrl = in.readString();
        this.uriPackageName = in.readString();
        this.uploadDataPackageName = in.readString();
        this.pushTimestamp = in.readString();
        this.paramsMap = in.readHashMap(this.getClass().getClassLoader());
        this.throughMessage = in.readString();
        this.notificationMessage = in.readString();
        this.mAdvanceSetting = (AdvanceSetting)in.readParcelable(AdvanceSetting.class.getClassLoader());
        this.mAppIconSetting = (AppIconSetting)in.readParcelable(AppIconSetting.class.getClassLoader());
        this.mNotificationStyle = (NotificationStyle)in.readParcelable(NotificationStyle.class.getClassLoader());
        this.mTimeDisplaySetting = (TimeDisplaySetting)in.readParcelable(TimeDisplaySetting.class.getClassLoader());
        this.whiteList = in.readByte() == 1;
        this.delayedReportMillis = in.readLong();
        this.mBrightRemindSetting = (BrightRemindSetting)in.readParcelable(BrightRemindSetting.class.getClassLoader());
        this.mAdvanceSettingEx = (AdvanceSettingEx)in.readParcelable(AdvanceSettingEx.class.getClassLoader());
        this.mAdvertisementOption = (AdvertisementOption)in.readParcelable(AdvertisementOption.class.getClassLoader());
    }

    public MessageV3() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flag) {
        parcel.writeString(this.taskId);
        parcel.writeString(this.seqId);
        parcel.writeString(this.deviceId);
        parcel.writeString(this.title);
        parcel.writeString(this.content);
        parcel.writeString(this.packageName);
        parcel.writeInt(this.clickType);
        parcel.writeByte((byte)(this.isDiscard ? 1 : 0));
        parcel.writeString(this.activity);
        parcel.writeString(this.webUrl);
        parcel.writeString(this.uriPackageName);
        parcel.writeString(this.uploadDataPackageName);
        parcel.writeString(this.pushTimestamp);
        parcel.writeMap(this.paramsMap);
        parcel.writeString(this.throughMessage);
        parcel.writeString(this.notificationMessage);
        parcel.writeParcelable((Parcelable)this.mAdvanceSetting, flag);
        parcel.writeParcelable((Parcelable)this.mAppIconSetting, flag);
        parcel.writeParcelable((Parcelable)this.mNotificationStyle, flag);
        parcel.writeParcelable((Parcelable)this.mTimeDisplaySetting, flag);
        parcel.writeByte((byte)(this.whiteList ? 1 : 0));
        parcel.writeLong(this.delayedReportMillis);
        parcel.writeParcelable((Parcelable)this.mBrightRemindSetting, flag);
        parcel.writeParcelable((Parcelable)this.mAdvanceSettingEx, flag);
        parcel.writeParcelable((Parcelable)this.mAdvertisementOption, flag);
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public AdvanceSetting getAdvanceSetting() {
        return this.mAdvanceSetting;
    }

    public void setAdvanceSetting(AdvanceSetting advanceSetting) {
        this.mAdvanceSetting = advanceSetting;
    }

    public AppIconSetting getAppIconSetting() {
        return this.mAppIconSetting;
    }

    public void setAppIconSetting(AppIconSetting mAppIconSetting) {
        this.mAppIconSetting = mAppIconSetting;
    }

    public NotificationStyle getNotificationStyle() {
        return this.mNotificationStyle;
    }

    public void setNotificationStyle(NotificationStyle mNotificationStyle) {
        this.mNotificationStyle = mNotificationStyle;
    }

    public TimeDisplaySetting getTimeDisplaySetting() {
        return this.mTimeDisplaySetting;
    }

    public void setTimeDisplaySetting(TimeDisplaySetting mTimeDisplaySetting) {
        this.mTimeDisplaySetting = mTimeDisplaySetting;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public int getClickType() {
        return this.clickType;
    }

    public void setClickType(int clickType) {
        this.clickType = clickType;
    }

    public boolean isDiscard() {
        return this.isDiscard;
    }

    public void setIsDiscard(boolean isDiscard) {
        this.isDiscard = isDiscard;
    }

    public String getActivity() {
        return this.activity;
    }

    public void setActivity(String activity) {
        this.activity = activity;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    public String getUriPackageName() {
        return this.uriPackageName;
    }

    public void setUriPackageName(String uriPackageName) {
        this.uriPackageName = uriPackageName;
    }

    public String getPushTimestamp() {
        return this.pushTimestamp;
    }

    public void setPushTimestamp(String pushTimestamp) {
        this.pushTimestamp = pushTimestamp;
    }

    public Map<String, String> getParamsMap() {
        return this.paramsMap;
    }

    public void setParamsMap(Map<String, String> paramsMap) {
        this.paramsMap = paramsMap;
    }

    public String getThroughMessage() {
        return this.throughMessage;
    }

    public void setThroughMessage(String throughMessage) {
        this.throughMessage = throughMessage;
    }

    public String getNotificationMessage() {
        return this.notificationMessage;
    }

    public void setNotificationMessage(String notificationMessage) {
        this.notificationMessage = notificationMessage;
    }

    public String getSeqId() {
        return this.seqId;
    }

    public void setSeqId(String seqId) {
        this.seqId = seqId;
    }

    public String getUploadDataPackageName() {
        return this.uploadDataPackageName;
    }

    public void setUploadDataPackageName(String uploadDataPackageName) {
        this.uploadDataPackageName = uploadDataPackageName;
    }

    public boolean getWhiteList() {
        return this.whiteList;
    }

    public void setWhiteList(boolean whiteList) {
        this.whiteList = whiteList;
    }

    public long getDelayedReportMillis() {
        return this.delayedReportMillis;
    }

    public void setDelayedReportMillis(long delayedReportMillis) {
        this.delayedReportMillis = delayedReportMillis;
    }

    public BrightRemindSetting getBrightRemindSetting() {
        return this.mBrightRemindSetting;
    }

    public void setBrightRemindSetting(BrightRemindSetting brightRemindSetting) {
        this.mBrightRemindSetting = brightRemindSetting;
    }

    public AdvanceSettingEx getAdvanceSettingEx() {
        return this.mAdvanceSettingEx;
    }

    public void setAdvanceSettingEx(AdvanceSettingEx advanceSettingEx) {
        this.mAdvanceSettingEx = advanceSettingEx;
    }

    public AdvertisementOption getAdvertisementOption() {
        return this.mAdvertisementOption;
    }

    public void setAdvertisementOption(AdvertisementOption advertisementOption) {
        this.mAdvertisementOption = advertisementOption;
    }

    public static MessageV3 parse(String packageName, String deviceId, String taskId, MPushMessage pushMessage) {
        DebugLogger.e(TAG, "V2 message " + pushMessage);
        MessageV3 messageV3 = new MessageV3();
        messageV3.setPackageName(packageName);
        messageV3.setUploadDataPackageName(packageName);
        messageV3.setDeviceId(deviceId);
        messageV3.setTaskId(taskId);
        messageV3.setTitle(pushMessage.getTitle());
        messageV3.setContent(pushMessage.getContent());
        messageV3.setIsDiscard("true".equals(pushMessage.getIsDiscard()));
        messageV3.setClickType(Integer.valueOf(pushMessage.getClickType()));
        messageV3.setWhiteList(false);
        messageV3.setDelayedReportMillis(0L);
        for (Map.Entry<String, String> extra : pushMessage.getExtra().entrySet()) {
            String key = extra.getKey();
            String value = extra.getValue();
            if ("activity".equals(key)) {
                messageV3.setActivity(value);
            }
            if ("url".equals(key)) {
                messageV3.setWebUrl(value);
            }
            if ("pk".equals(key)) {
                messageV3.setUriPackageName(value);
            }
            if ("ns".equals(key)) {
                messageV3.setNotificationStyle(NotificationStyle.parse(value));
            }
            if ("as".equals(key)) {
                messageV3.setAdvanceSetting(AdvanceSetting.parse(value));
            }
            if ("is".equals(key)) {
                messageV3.setAppIconSetting(AppIconSetting.parse(value));
            }
            if ("ts".equals(key)) {
                messageV3.setTimeDisplaySetting(TimeDisplaySetting.parse(value));
            }
            if ("bs".equals(key)) {
                messageV3.setBrightRemindSetting(BrightRemindSetting.parse(value));
            }
            if ("as".equals(key)) {
                messageV3.setAdvanceSettingEx(AdvanceSettingEx.parse(value));
            }
            if (!"ado".equals(key)) continue;
            messageV3.setAdvertisementOption(AdvertisementOption.parse(value));
        }
        messageV3.setParamsMap(pushMessage.getParams());
        String extraJson = Util.mapToJsonObject(pushMessage.getExtra()).toString();
        DebugLogger.e(TAG, "MessageV2 extra json is " + extraJson);
        if (!TextUtils.isEmpty((CharSequence)extraJson)) {
            messageV3.setNotificationMessage(extraJson);
        }
        DebugLogger.i(TAG, "parse V2 message to V3 message " + messageV3);
        return messageV3;
    }

    public static MessageV3 parse(String packageName, String deviceId, String taskId, String pushMessage) {
        return MessageV3.parse(packageName, null, null, deviceId, taskId, null, pushMessage, false, 0L);
    }

    public static MessageV3 parse(String packageName, String deviceId, String taskId, String seqId, String pushMessage) {
        return MessageV3.parse(packageName, null, null, deviceId, taskId, seqId, pushMessage, false, 0L);
    }

    public static MessageV3 parse(String packageName, String uploadDataPackageName, String timestamp, String deviceId, String taskId, String seqId, String pushMessage) {
        return MessageV3.parse(packageName, uploadDataPackageName, timestamp, deviceId, taskId, seqId, pushMessage, false, 0L);
    }

    public static MessageV3 parse(String packageName, String uploadDataPackageName, String timestamp, String deviceId, String taskId, String seqId, String pushMessage, boolean whiteList, long delayedReportMillis) {
        MessageV3 messageV3 = new MessageV3();
        if (!packageName.isEmpty()) {
            messageV3.setPackageName(packageName);
        }
        if (!uploadDataPackageName.isEmpty()) {
            messageV3.setUploadDataPackageName(uploadDataPackageName);
        }
        if (!timestamp.isEmpty()) {
            messageV3.setPushTimestamp(timestamp);
        }
        if (!deviceId.isEmpty()) {
            messageV3.setDeviceId(deviceId);
        }
        if (!taskId.isEmpty()) {
            messageV3.setTaskId(taskId);
        }
        if (!seqId.isEmpty()) {
            messageV3.setSeqId(seqId);
        }
        if (!pushMessage.isEmpty()) {
            messageV3.setNotificationMessage(pushMessage);
        }
        messageV3.setWhiteList(whiteList);
        messageV3.setDelayedReportMillis(delayedReportMillis);
        try {
            JSONObject pushDataObj = new JSONObject(pushMessage);
            JSONObject pushMessageObj = pushDataObj.getJSONObject("data");
            if (!pushMessageObj.isNull("title")) {
                messageV3.setTitle(pushMessageObj.getString("title"));
            }
            if (!pushMessageObj.isNull("content")) {
                messageV3.setContent(pushMessageObj.getString("content"));
            }
            if (!pushMessageObj.isNull("isDiscard")) {
                messageV3.setIsDiscard(pushMessageObj.getBoolean("isDiscard"));
            }
            if (!pushMessageObj.isNull("clickType")) {
                messageV3.setClickType(pushMessageObj.getInt("clickType"));
            }
            if (!pushMessageObj.isNull("extra")) {
                JSONObject extraObj = pushMessageObj.getJSONObject("extra");
                if (!extraObj.isNull("ns")) {
                    messageV3.setNotificationStyle(NotificationStyle.parse(extraObj.getJSONObject("ns")));
                }
                if (!extraObj.isNull("is")) {
                    messageV3.setAppIconSetting(AppIconSetting.parse(extraObj.getJSONObject("is")));
                }
                if (!extraObj.isNull("as")) {
                    messageV3.setAdvanceSetting(AdvanceSetting.parse(extraObj.getJSONObject("as")));
                }
                if (!extraObj.isNull("ts")) {
                    messageV3.setTimeDisplaySetting(TimeDisplaySetting.parse(extraObj.getJSONObject("ts")));
                }
                if (!extraObj.isNull("activity")) {
                    messageV3.setActivity(extraObj.getString("activity"));
                }
                if (!extraObj.isNull("url")) {
                    messageV3.setWebUrl(extraObj.getString("url"));
                }
                if (!extraObj.isNull("task_id") && TextUtils.isEmpty((CharSequence)taskId)) {
                    DebugLogger.e(TAG, "Flyme 4 notification message by through message or taskId is null");
                    messageV3.setTaskId(extraObj.getString("task_id"));
                }
                if (!extraObj.isNull("pk")) {
                    messageV3.setUriPackageName(extraObj.getString("pk"));
                }
                if (!extraObj.isNull("parameters")) {
                    messageV3.setParamsMap(MessageV3.getParamsMap(extraObj.getJSONObject("parameters")));
                }
                if (!extraObj.isNull("bs")) {
                    messageV3.setBrightRemindSetting(BrightRemindSetting.parse(extraObj.getJSONObject("bs")));
                }
                if (!extraObj.isNull("as")) {
                    messageV3.setAdvanceSettingEx(AdvanceSettingEx.parse(extraObj.getJSONObject("as")));
                }
                if (!extraObj.isNull("ado")) {
                    messageV3.setAdvertisementOption(AdvertisementOption.parse(extraObj.getJSONObject("ado")));
                }
            }
        }
        catch (JSONException e) {
            DebugLogger.e(TAG, "parse message error " + e.getMessage());
        }
        return messageV3;
    }

    private static Map<String, String> getParamsMap(JSONObject paramsJsonObject) {
        try {
            HashMap<String, String> paramsMap = new HashMap<String, String>(paramsJsonObject.length());
            Iterator extraIterator = paramsJsonObject.keys();
            while (extraIterator.hasNext()) {
                String key = (String)extraIterator.next();
                String value = paramsJsonObject.getString(key);
                paramsMap.put(key, value);
            }
            return paramsMap;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "MessageV3{taskId='" + this.taskId + '\'' + ", seqId='" + this.seqId + '\'' + ", deviceId='" + this.deviceId + '\'' + ", title='" + this.title + '\'' + ", content='" + this.content + '\'' + ", packageName='" + this.packageName + '\'' + ", clickType=" + this.clickType + '\'' + ", isDiscard=" + this.isDiscard + '\'' + ", activity='" + this.activity + '\'' + ", webUrl='" + this.webUrl + '\'' + ", uriPackageName='" + this.uriPackageName + '\'' + ", pushTimestamp='" + this.pushTimestamp + '\'' + ", uploadDataPackageName='" + this.uploadDataPackageName + '\'' + ", paramsMap=" + this.paramsMap + '\'' + ", throughMessage='" + this.throughMessage + '\'' + ", notificationMessage='" + this.notificationMessage + '\'' + ", mAdvanceSetting=" + this.mAdvanceSetting + '\'' + ", mAppIconSetting=" + this.mAppIconSetting + '\'' + ", mNotificationStyle=" + this.mNotificationStyle + '\'' + ", mTimeDisplaySetting=" + this.mTimeDisplaySetting + '\'' + ", whiteList=" + this.whiteList + '\'' + ", delayedReportMillis=" + this.delayedReportMillis + ", BrightRemindSetting=" + this.mBrightRemindSetting + ", mAdvanceSettingEx=" + this.mAdvanceSettingEx + '\'' + ", mAdvertisementOption=" + this.mAdvertisementOption + '\'' + '}';
    }

    public static enum CLICK_TYPE_DEFINE {
        CLICK_TYPE_LAUNCHER_ACTIVITY,
        CLICK_TYPE_ACTIVITY,
        CLICK_TYPE_WEB;

    }
}

