/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseArray;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.PushMessageProxy;
import com.meizu.cloud.pushsdk.base.DeviceUtils;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.MessageHandler;
import com.meizu.cloud.pushsdk.handler.MessageSerialize;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.handler.MzPushMessage;
import com.meizu.cloud.pushsdk.handler.impl.Advertisement.AdNotification;
import com.meizu.cloud.pushsdk.handler.impl.model.SecurityMessage;
import com.meizu.cloud.pushsdk.networking.AndroidNetworking;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.notification.model.NotifyOption;
import com.meizu.cloud.pushsdk.notification.util.NotificationUtils;
import com.meizu.cloud.pushsdk.platform.api.PushPlatformManager;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import com.meizu.cloud.pushsdk.util.RSAUtils;
import org.json.JSONObject;

public abstract class AbstractMessageHandler<T>
implements MessageHandler {
    protected static final String TAG = "AbstractMessageHandler";
    private static final int RETRY_DOWNLOAD_PUBLIC_KEY_COUNT = 2;
    private static final String LAUNCHER_JSON_KEY = "launcher";
    private static final String LAUNCHER_JSON_SUB_KEY = "pkg";
    private static final String NOTIFICATION_APP_ID_KEY = "appId";
    protected static final int MESSAGE_TYPE_PUSH_SERVICE_V2 = 2;
    protected static final int MESSAGE_TYPE_PUSH_SERVICE_V3 = 4;
    protected static final int MESSAGE_TYPE_THROUGH = 8;
    protected static final int MESSAGE_TYPE_REGISTER = 16;
    protected static final int MESSAGE_TYPE_UNREGISTER = 32;
    protected static final int MESSAGE_TYPE_NOTIFICATION_CLICK = 64;
    protected static final int MESSAGE_TYPE_NOTIFICATION_DELETE = 128;
    protected static final int MESSAGE_TYPE_PUSH_SWITCH_STATUS = 256;
    protected static final int MESSAGE_TYPE_PUSH_REGISTER_STATUS = 512;
    protected static final int MESSAGE_TYPE_PUSH_UNREGISTER_STATUS = 1024;
    protected static final int MESSAGE_TYPE_PUSH_SUBTAGS_STATUS = 2048;
    protected static final int MESSAGE_TYPE_PUSH_SUBALIAS_STATUS = 4096;
    protected static final int MESSAGE_TYPE_SCHEDULE_NOTIFICATION = 8192;
    protected static final int MESSAGE_TYPE_RECEIVE_NOTIFY_MESSAGE = 16384;
    protected static final int MESSAGE_TYPE_NOTIFICATION_STATE = 32768;
    protected static final int MESSAGE_TYPE_UPLOAD_FILE_LOG = 65536;
    protected static final int MESSAGE_TYPE_NOTIFICATION_ARRIVED = 131072;
    protected static final int MESSAGE_TYPE_NOTIFICATION_WITHDRAW = 262144;
    protected static final int MESSAGE_TYPE_BRIGHT_NOTIFICATION = 524288;
    protected static final int MESSAGE_TYPE_NOTIFICATION_CLOSE = 0x100000;
    private AbstractAppLogicListener abstractAppLogicListener;
    private Context context;
    private SparseArray<String> messageHandlerMap;
    protected static final int SCHEDULE_OFF = 0;
    protected static final int SCHEDULE_ON_EXPIRE = 1;
    protected static final int SCHEDULE_ON_TIME = 2;
    protected static final int SCHEDULE_ON_DELAY = 3;
    protected static final int SCHEDULE_ON_BRIGHT = 4;
    protected static final int AD_CANNOT_SHOW_MESSAGE = 5;

    protected AbstractMessageHandler(Context context) {
        this(context, null);
    }

    protected AbstractMessageHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null.");
        }
        this.context = context.getApplicationContext();
        this.abstractAppLogicListener = abstractAppLogicListener;
        this.messageHandlerMap = new SparseArray();
        this.messageHandlerMap.put(2, (Object)"MESSAGE_TYPE_PUSH_SERVICE_V2");
        this.messageHandlerMap.put(4, (Object)"MESSAGE_TYPE_PUSH_SERVICE_V3");
        this.messageHandlerMap.put(16, (Object)"MESSAGE_TYPE_REGISTER");
        this.messageHandlerMap.put(32, (Object)"MESSAGE_TYPE_UNREGISTER");
        this.messageHandlerMap.put(8, (Object)"MESSAGE_TYPE_THROUGH");
        this.messageHandlerMap.put(64, (Object)"MESSAGE_TYPE_NOTIFICATION_CLICK");
        this.messageHandlerMap.put(128, (Object)"MESSAGE_TYPE_NOTIFICATION_DELETE");
        this.messageHandlerMap.put(256, (Object)"MESSAGE_TYPE_PUSH_SWITCH_STATUS");
        this.messageHandlerMap.put(512, (Object)"MESSAGE_TYPE_PUSH_REGISTER_STATUS");
        this.messageHandlerMap.put(2048, (Object)"MESSAGE_TYPE_PUSH_SUBTAGS_STATUS");
        this.messageHandlerMap.put(1024, (Object)"MESSAGE_TYPE_PUSH_UNREGISTER_STATUS");
        this.messageHandlerMap.put(4096, (Object)"MESSAGE_TYPE_PUSH_SUBALIAS_STATUS");
        this.messageHandlerMap.put(8192, (Object)"MESSAGE_TYPE_SCHEDULE_NOTIFICATION");
        this.messageHandlerMap.put(16384, (Object)"MESSAGE_TYPE_RECEIVE_NOTIFY_MESSAGE");
        this.messageHandlerMap.put(32768, (Object)"MESSAGE_TYPE_NOTIFICATION_STATE");
        this.messageHandlerMap.put(65536, (Object)"MESSAGE_TYPE_UPLOAD_FILE_LOG");
        this.messageHandlerMap.put(131072, (Object)"MESSAGE_TYPE_NOTIFICATION_ARRIVED");
        this.messageHandlerMap.put(262144, (Object)"MESSAGE_TYPE_NOTIFICATION_WITHDRAW");
        this.messageHandlerMap.put(524288, (Object)"MESSAGE_TYPE_BRIGHT_NOTIFICATION");
        this.messageHandlerMap.put(0x100000, (Object)"MESSAGE_TYPE_NOTIFICATION_CLOSE");
    }

    protected abstract T getMessage(Intent var1);

    protected abstract void unsafeSend(T var1, PushNotification var2);

    protected PushNotification onCreateNotification(T message) {
        return null;
    }

    protected void onBeforeEvent(T message) {
    }

    protected void onAfterEvent(T message) {
    }

    protected int scheduleNotificationStatus(T message) {
        return 0;
    }

    protected void scheduleShowNotification(T message) {
    }

    protected void brightShowNotification(T message) {
    }

    protected boolean canSendMessage(T message) {
        return true;
    }

    protected boolean securityCheck(T message, String messageMethod) {
        return true;
    }

    protected final boolean securityCheckMessage(MessageV3 message, String messageMethod) {
        String encryptSign = SecurityMessage.getSecurityEncryption(message);
        if (TextUtils.isEmpty((CharSequence)encryptSign)) {
            DebugLogger.i(TAG, "message does not contain signature field");
            return false;
        }
        String publicKey = PushPreferencesUtils.getPublicKeyByPackageName(this.context(), message.getPackageName());
        DebugLogger.i(TAG, "local public key is: " + publicKey);
        if (this.isSpecialApprovalNoCheck(publicKey, message, messageMethod)) {
            DebugLogger.i(TAG, "message special approval no check");
            return true;
        }
        if (this.checkPublicKey(publicKey, message, encryptSign)) {
            DebugLogger.i(TAG, "security check passed");
            return true;
        }
        publicKey = this.getNetworkRequestPublicKey();
        DebugLogger.i(TAG, "network request public key: " + publicKey);
        if (this.checkPublicKey(publicKey, message, encryptSign)) {
            PushPreferencesUtils.putPublicKeyByPackageName(this.context(), message.getPackageName(), publicKey);
            DebugLogger.i(TAG, "security check passed");
            return true;
        }
        DebugLogger.e(TAG, "security check fail");
        return false;
    }

    private boolean isSpecialApprovalNoCheck(String publicKey, MessageV3 message, String messageMethod) {
        if (!TextUtils.isEmpty((CharSequence)publicKey)) {
            DebugLogger.i(TAG, "sa, public key not empty");
            return false;
        }
        if (!"private".equals(messageMethod)) {
            DebugLogger.i(TAG, "sa, message not click method");
            return false;
        }
        if (!PushPreferencesUtils.getFirstRequestPublicKey(this.context(), message.getPackageName())) {
            DebugLogger.i(TAG, "sa, not first request");
            return false;
        }
        PushPreferencesUtils.putFirstRequestPublicKey(this.context(), message.getPackageName(), false);
        return true;
    }

    private boolean checkPublicKey(String publicKey, MessageV3 message, String encryptSign) {
        if (TextUtils.isEmpty((CharSequence)publicKey)) {
            DebugLogger.e(TAG, "security check fail, public key is null");
            return false;
        }
        String decryptSign = RSAUtils.decrypt(publicKey, encryptSign);
        DebugLogger.i(TAG, "decrypt sign: " + decryptSign);
        boolean checkResult = SecurityMessage.check(decryptSign, message);
        DebugLogger.i(TAG, "check public key result: " + checkResult);
        return checkResult;
    }

    private String getNetworkRequestPublicKey() {
        String publicKey = null;
        for (int i = 0; i < 2 && TextUtils.isEmpty((CharSequence)(publicKey = this.networkRequestPublicKey())); ++i) {
        }
        return publicKey;
    }

    protected String networkRequestPublicKey() {
        ANResponse anResponse = AndroidNetworking.get("https://api-push.meizu.com/garcia/api/server/getPublicKey").build().executeForString();
        SecurityMessage.PublicKeyStatus publicKeyStatus = new SecurityMessage.PublicKeyStatus((String)anResponse.getResult());
        return publicKeyStatus.getPublicKey();
    }

    protected String getDeviceId(Intent intent) {
        String deviceId = null;
        if (intent != null) {
            deviceId = intent.getStringExtra("statistics_imei_key");
        }
        if (TextUtils.isEmpty(deviceId)) {
            deviceId = DeviceUtils.getDeviceId(this.context());
            DebugLogger.e(TAG, "force get deviceId " + deviceId);
        }
        return deviceId;
    }

    protected String getTaskId(Intent intent) {
        return intent.getStringExtra("extra_app_push_task_Id");
    }

    protected String getSeqId(Intent intent) {
        return intent.getStringExtra("extra_app_push_seq_Id");
    }

    protected String getPushServiceDefaultPackageName(Intent intent) {
        String defaultPackageName = intent.getStringExtra("extra_app_push_service_default_package_name");
        if (TextUtils.isEmpty((CharSequence)defaultPackageName)) {
            defaultPackageName = this.context().getPackageName();
        }
        return defaultPackageName;
    }

    protected String getPushTimestamp(Intent intent) {
        String pushTimestamp = intent.getStringExtra("extra_app_push_task_timestamp");
        DebugLogger.i(TAG, "receive push timestamp from pushservice " + pushTimestamp);
        if (TextUtils.isEmpty((CharSequence)pushTimestamp)) {
            pushTimestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        }
        return pushTimestamp;
    }

    protected boolean getWhiteList(Intent intent) {
        boolean whiteList = intent.getBooleanExtra("mz_push_white_list", false);
        DebugLogger.i(TAG, "receive push whiteList from pushservice " + whiteList);
        return whiteList;
    }

    protected long getDelayedReportMillis(Intent intent) {
        long delayedReportMillis = intent.getLongExtra("mz_push_delayed_report_millis", 0L);
        DebugLogger.i(TAG, "receive push delayedReportMillis from pushservice " + delayedReportMillis);
        return delayedReportMillis;
    }

    @Override
    public boolean sendMessage(Intent intent) {
        if (!this.messageMatch(intent)) {
            return false;
        }
        boolean flag = false;
        DebugLogger.i(TAG, "current message Type " + this.getMessageHandlerType(this.getProcessorType()));
        T message = this.getMessage(intent);
        if (!this.securityCheck(message, this.getIntentMethod(intent))) {
            DebugLogger.e(TAG, "invalid push message");
            return false;
        }
        DebugLogger.i(TAG, "current Handler message " + message);
        this.onBeforeEvent(message);
        boolean isCustomSend = false;
        switch (this.scheduleNotificationStatus(message)) {
            case 0: {
                DebugLogger.i(TAG, "schedule send message off, send message directly");
                isCustomSend = true;
                flag = true;
                break;
            }
            case 1: {
                DebugLogger.i(TAG, "expire notification, don't show message");
                flag = false;
                break;
            }
            case 2: {
                DebugLogger.i(TAG, "notification on time ,show message");
                isCustomSend = true;
                flag = true;
                break;
            }
            case 3: {
                DebugLogger.i(TAG, "schedule notification");
                this.scheduleShowNotification(message);
                flag = true;
                break;
            }
            case 4: {
                DebugLogger.i(TAG, "bright notification");
                this.brightShowNotification(message);
                flag = true;
                break;
            }
            case 5: {
                DebugLogger.i(TAG, "ad cannot show message");
                flag = false;
                break;
            }
        }
        boolean canSend = this.canSendMessage(message);
        DebugLogger.i(TAG, "can send message " + canSend);
        if (flag && isCustomSend && canSend) {
            this.unsafeSend(message, this.onCreateNotification(message));
            this.onAfterEvent(message);
            DebugLogger.i(TAG, "send message end ");
        }
        return flag;
    }

    protected AbstractAppLogicListener appLogicListener() {
        return this.abstractAppLogicListener;
    }

    protected Context context() {
        return this.context;
    }

    protected String getIntentMethod(Intent intent) {
        return intent.getStringExtra("method");
    }

    protected boolean isNotificationJson(String notificationJson) {
        try {
            JSONObject pushMessageObj = new JSONObject(notificationJson);
            return this.context().getPackageName().equals(pushMessageObj.getString(NOTIFICATION_APP_ID_KEY));
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "parse notification error");
            return false;
        }
    }

    public String getDeskTopNotificationPkg(String deskTopNotificationJson) {
        String pkg = "";
        try {
            JSONObject deskTopNotificationJsonObj = new JSONObject(deskTopNotificationJson);
            JSONObject launcherObj = deskTopNotificationJsonObj.getJSONObject(LAUNCHER_JSON_KEY);
            if (launcherObj.has(LAUNCHER_JSON_SUB_KEY) && !TextUtils.isEmpty((CharSequence)launcherObj.getString(LAUNCHER_JSON_SUB_KEY))) {
                pkg = launcherObj.getString(LAUNCHER_JSON_SUB_KEY);
            }
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "parse desk top json error");
        }
        return pkg;
    }

    private String getMessageHandlerType(int type) {
        return (String)this.messageHandlerMap.get(type);
    }

    protected boolean canReceiveMessage(int pushType, String destPackageName) {
        boolean flag = true;
        if (pushType == 0) {
            flag = PushPreferencesUtils.getNotificationMessageSwitchStatus(this.context(), destPackageName);
        } else if (pushType == 1) {
            flag = PushPreferencesUtils.getThroughMessageSwitchStatus(this.context(), destPackageName);
        }
        DebugLogger.i(TAG, destPackageName + (pushType == 0 ? " canNotificationMessage " : " canThroughMessage ") + flag);
        return flag;
    }

    protected void sendArrivedMessage(MessageV3 message) {
        if (message != null && message.getAdvertisementOption() != null && !TextUtils.isEmpty((CharSequence)message.getAdvertisementOption().getAdPackage())) {
            return;
        }
        if (!MinSdkChecker.isSupportSetDrawableSmallIcon()) {
            this.appLogicListener().onNotificationArrived(this.context(), MzPushMessage.fromMessageV3(message));
        } else if (MzSystemUtils.isRunningProcess(this.context(), message.getUploadDataPackageName())) {
            DebugLogger.i(TAG, "send notification arrived message to " + message.getUploadDataPackageName());
            Intent arrivedIntent = new Intent();
            if (MinSdkChecker.isSupportTransmitMessageValue(this.context, message.getUploadDataPackageName())) {
                arrivedIntent.putExtra("messageValue", MessageSerialize.messageV3ToString(message));
            } else {
                arrivedIntent.putExtra("pushMessage", (Parcelable)message);
            }
            arrivedIntent.putExtra("method", "notification_arrived");
            MzSystemUtils.sendMessageFromBroadcast(this.context(), arrivedIntent, "com.meizu.flyme.push.intent.MESSAGE", message.getUploadDataPackageName());
        }
    }

    protected void clearNotification(MessageV3 message) {
        if (!MinSdkChecker.isSupportSetDrawableSmallIcon()) {
            this.clearNotifyOption(message);
        } else {
            NotifyOption notifyOption = NotifyOption.getNotifyOptionSetting(message);
            if (notifyOption != null) {
                DebugLogger.e(TAG, "delete notifyId " + notifyOption.getNotifyId() + " notifyKey " + notifyOption.getNotifyKey());
                if (!TextUtils.isEmpty((CharSequence)notifyOption.getNotifyKey())) {
                    PushPlatformManager.getInstance(this.context()).clearNotifyKey(message.getUploadDataPackageName(), notifyOption.getNotifyKey());
                } else {
                    PushPlatformManager.getInstance(this.context()).clearNotification(message.getUploadDataPackageName(), notifyOption.getNotifyId());
                }
            }
        }
    }

    protected void clearNotifyOption(MessageV3 message) {
        NotifyOption notifyOption = NotifyOption.getNotifyOptionSetting(message);
        if (notifyOption != null) {
            DebugLogger.i(TAG, "delete notifyKey " + notifyOption.getNotifyKey() + " notifyId " + notifyOption.getNotifyId());
            if (!TextUtils.isEmpty((CharSequence)notifyOption.getNotifyKey())) {
                NotificationUtils.removeNotifyKey(this.context(), message.getUploadDataPackageName(), notifyOption.getNotifyKey());
            } else {
                NotificationUtils.removeNotifyIdByPackageName(this.context(), message.getUploadDataPackageName(), notifyOption.getNotifyId());
            }
        }
    }

    protected void cleanAdNotificationInfo(Context context, MessageV3 message) {
        NotifyOption notifyOption;
        AdNotification adNotification;
        if (message.getAdvertisementOption() != null && !TextUtils.isEmpty((CharSequence)message.getAdvertisementOption().getAdPackage()) && (adNotification = PushMessageProxy.with(context).getAdNotification()) != null && (notifyOption = NotifyOption.getNotifyOptionSetting(message)) != null) {
            adNotification.cleanAdNotification(notifyOption.getNotifyId());
        }
    }
}

