/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl.Advertisement;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.base.alarm.AlarmUtils;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.notification.model.AdvanceSetting;
import com.meizu.cloud.pushsdk.notification.model.AdvanceSettingEx;

public class AdNotification {
    private static final String TAG = "AdNotification";
    private Context mContext;
    private AlarmUtils mAlarmUtils;
    private int mNotifyId;
    private Notification mNotification;

    public AdNotification(Context context) {
        this.mContext = context;
    }

    public void reduceMessagePriority(MessageV3 messageV3) {
        AdvanceSettingEx advanceSettingEx;
        AdvanceSetting advanceSetting = messageV3.getAdvanceSetting();
        if (advanceSetting != null) {
            advanceSetting.getNotifyType().setSound(false);
            advanceSetting.getNotifyType().setLights(false);
            advanceSetting.getNotifyType().setVibrate(false);
        }
        if ((advanceSettingEx = messageV3.getAdvanceSettingEx()) != null) {
            advanceSettingEx.setSoundTitle(null);
            if (Build.VERSION.SDK_INT >= 29 && advanceSetting != null && advanceSetting.isHeadUpNotification()) {
                advanceSettingEx.setPriorityDisplay(1);
            } else {
                advanceSettingEx.setPriorityDisplay(0);
            }
        }
    }

    public void saveAdNotification(int notifyId, Notification notification, int priorityValidTime) {
        if (notifyId <= 0 || notification == null) {
            return;
        }
        this.save(notifyId, notification);
        this.schedulePriorityValidTime(priorityValidTime);
        DebugLogger.d(TAG, "save ad notification, notifyId:" + notifyId);
    }

    private void schedulePriorityValidTime(int priorityValidTime) {
        if (priorityValidTime <= 0) {
            return;
        }
        if (this.mAlarmUtils != null) {
            try {
                this.mAlarmUtils.cancel();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.mAlarmUtils = null;
            }
        }
        this.mAlarmUtils = new AlarmUtils(this.mContext, new Runnable(){

            @Override
            public void run() {
                DebugLogger.d(AdNotification.TAG, "ad priority valid time out");
                AdNotification.this.againShowOldAdNotification();
            }
        }, priorityValidTime * 60 * 1000);
        this.mAlarmUtils.start();
    }

    public void againShowOldAdNotification() {
        if (this.mNotifyId <= 0 || this.mNotification == null) {
            return;
        }
        try {
            NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
            notificationManager.notify(this.mNotifyId, this.mNotification);
            DebugLogger.d(TAG, "again show old ad notification, notifyId:" + this.mNotifyId);
        }
        catch (Exception e) {
            e.printStackTrace();
            DebugLogger.e(TAG, "again show old ad notification error:" + e.getMessage());
        }
        this.clean();
    }

    public void cleanAdNotification(int notifyId) {
        if (notifyId <= 0 || this.mNotifyId <= 0 || notifyId != this.mNotifyId) {
            return;
        }
        this.clean();
        DebugLogger.d(TAG, "clean ad notification, notifyId:" + notifyId);
    }

    private void save(int notifyId, Notification notification) {
        this.mNotifyId = notifyId;
        this.mNotification = notification;
    }

    private void clean() {
        this.mNotifyId = 0;
        this.mNotification = null;
        if (this.mAlarmUtils != null) {
            try {
                this.mAlarmUtils.cancel();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.mAlarmUtils = null;
            }
        }
    }
}

