/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl;

import android.content.Context;
import android.content.Intent;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.handler.MzPushMessage;
import com.meizu.cloud.pushsdk.handler.impl.MessageV3Handler;
import com.meizu.cloud.pushsdk.notification.MPushMessage;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.util.UxIPUtils;

public class MessageV2Handler
extends MessageV3Handler {
    public MessageV2Handler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i("AbstractMessageHandler", "start MessageV2Handler match");
        if (!this.canReceiveMessage(0, this.getPushServiceDefaultPackageName(intent))) {
            return false;
        }
        return "com.meizu.flyme.push.intent.MESSAGE".equals(intent.getAction()) && "notification_show".equals(this.getIntentMethod(intent));
    }

    @Override
    public int getProcessorType() {
        return 2;
    }

    @Override
    protected MessageV3 getMessage(Intent intent) {
        MPushMessage mPushMessage = (MPushMessage)intent.getSerializableExtra("pushMessage");
        return MessageV3.parse(this.getPushServiceDefaultPackageName(intent), this.getDeviceId(intent), mPushMessage.getTaskId(), mPushMessage);
    }

    @Override
    protected void unsafeSend(MessageV3 message, PushNotification pushNotification) {
        if (pushNotification != null) {
            pushNotification.show(message);
            this.appLogicListener().onNotificationArrived(this.context(), MzPushMessage.fromMessageV3(message));
        }
    }

    @Override
    protected void onBeforeEvent(MessageV3 message) {
        UxIPUtils.onReceivePushMessageEvent(this.context(), message.getUploadDataPackageName(), message.getDeviceId(), message.getTaskId(), message.getSeqId(), message.getPushTimestamp(), message.getDelayedReportMillis());
    }

    @Override
    protected void onAfterEvent(MessageV3 message) {
        UxIPUtils.onShowPushMessageEvent(this.context(), message.getUploadDataPackageName(), message.getDeviceId(), message.getTaskId(), message.getSeqId(), message.getPushTimestamp(), message.getDelayedReportMillis());
    }
}

