/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.NotificationService;
import com.meizu.cloud.pushsdk.PushMessageProxy;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.handler.MzPushMessage;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.schedule.BrightNotification;
import com.meizu.cloud.pushsdk.notification.AbstractPushNotification;
import com.meizu.cloud.pushsdk.notification.PictureNotification;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.notification.StandardNotificationV2;
import com.meizu.cloud.pushsdk.notification.android.AndroidExpandablePicNotification;
import com.meizu.cloud.pushsdk.notification.android.AndroidExpandableTextNotification;
import com.meizu.cloud.pushsdk.notification.android.AndroidStandardNotification;
import com.meizu.cloud.pushsdk.notification.android.AndroidVideoNotification;
import com.meizu.cloud.pushsdk.notification.flyme.ExpandablePicNotification;
import com.meizu.cloud.pushsdk.notification.flyme.ExpandableTextNotification;
import com.meizu.cloud.pushsdk.notification.flyme.StandardNotification;
import com.meizu.cloud.pushsdk.notification.model.styleenum.BaseStyleModel;
import com.meizu.cloud.pushsdk.notification.model.styleenum.InnerStyleLayout;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import com.meizu.cloud.pushsdk.util.UxIPUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageV3Handler
extends AbstractMessageHandler<MessageV3> {
    private static final int CLOSE_AD_INTERVAL = 1209600000;

    public MessageV3Handler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    protected MessageV3 getMessage(Intent intent) {
        String pushMessage = "notification_show_v3".equals(this.getIntentMethod(intent)) ? intent.getStringExtra("pushMessage") : intent.getStringExtra("message");
        return MessageV3.parse(this.context().getPackageName(), this.getPushServiceDefaultPackageName(intent), this.getPushTimestamp(intent), this.getDeviceId(intent), this.getTaskId(intent), this.getSeqId(intent), pushMessage, this.getWhiteList(intent), this.getDelayedReportMillis(intent));
    }

    @Override
    protected boolean securityCheck(MessageV3 message, String messageMethod) {
        return this.securityCheckMessage(message, messageMethod);
    }

    @Override
    protected void unsafeSend(MessageV3 message, PushNotification pushNotification) {
        if (pushNotification != null) {
            pushNotification.show(message);
            this.sendArrivedMessage(message);
        }
    }

    @Override
    protected PushNotification onCreateNotification(MessageV3 messageV3) {
        PushNotificationBuilder pushNotificationBuilder = new PushNotificationBuilder(this.context());
        pushNotificationBuilder.setClickPackageName(this.getQuickPackageName(messageV3));
        this.appLogicListener().onUpdateNotificationBuilder(pushNotificationBuilder);
        AbstractPushNotification pushNotification = null;
        if (messageV3.getNotificationStyle() != null) {
            int baseStyle = messageV3.getNotificationStyle().getBaseStyle();
            if (BaseStyleModel.FLYME.getCode() == baseStyle) {
                int innerStyle = messageV3.getNotificationStyle().getInnerStyle();
                if (InnerStyleLayout.EXPANDABLE_STANDARD.getCode() == innerStyle) {
                    DebugLogger.i("AbstractMessageHandler", "show Standard Notification with Expandable disable");
                    pushNotification = new StandardNotification(this.context(), pushNotificationBuilder);
                } else if (InnerStyleLayout.EXPANDABLE_TEXT.getCode() == innerStyle) {
                    DebugLogger.i("AbstractMessageHandler", "show Standard Notification with Expandable Text");
                    pushNotification = new ExpandableTextNotification(this.context(), pushNotificationBuilder);
                } else if (InnerStyleLayout.EXPANDABLE_PIC.getCode() == innerStyle) {
                    DebugLogger.i("AbstractMessageHandler", "show Standard Notification with Expandable Picture");
                    pushNotification = new ExpandablePicNotification(this.context(), pushNotificationBuilder);
                } else if (InnerStyleLayout.EXPANDABLE_VIDEO.getCode() == innerStyle) {
                    DebugLogger.i("AbstractMessageHandler", "show Flyme Video notification");
                    pushNotification = new AndroidVideoNotification(this.context(), pushNotificationBuilder);
                }
            } else if (BaseStyleModel.PURE_PICTURE.getCode() == baseStyle) {
                pushNotification = new PictureNotification(this.context(), pushNotificationBuilder);
                DebugLogger.i("AbstractMessageHandler", "show Pure Picture Notification");
            } else if (BaseStyleModel.ANDROID.getCode() == baseStyle) {
                int innerStyle = messageV3.getNotificationStyle().getInnerStyle();
                if (InnerStyleLayout.EXPANDABLE_STANDARD.getCode() == innerStyle) {
                    DebugLogger.i("AbstractMessageHandler", "show Android  Notification with Expandable disable");
                    pushNotification = new AndroidStandardNotification(this.context(), pushNotificationBuilder);
                } else if (InnerStyleLayout.EXPANDABLE_TEXT.getCode() == innerStyle) {
                    DebugLogger.i("AbstractMessageHandler", "show Android  Notification with Expandable Text");
                    pushNotification = new AndroidExpandableTextNotification(this.context(), pushNotificationBuilder);
                } else if (InnerStyleLayout.EXPANDABLE_PIC.getCode() == innerStyle) {
                    DebugLogger.i("AbstractMessageHandler", "show Android  Notification with Expandable Picture");
                    pushNotification = new AndroidExpandablePicNotification(this.context(), pushNotificationBuilder);
                } else if (InnerStyleLayout.EXPANDABLE_VIDEO.getCode() == innerStyle) {
                    DebugLogger.i("AbstractMessageHandler", "show Flyme Video notification");
                    pushNotification = new AndroidVideoNotification(this.context(), pushNotificationBuilder);
                }
            }
        }
        if (pushNotification == null) {
            DebugLogger.e("AbstractMessageHandler", "use standard v2 notification");
            pushNotification = new StandardNotificationV2(this.context(), pushNotificationBuilder);
        }
        return pushNotification;
    }

    @Override
    protected boolean canSendMessage(MessageV3 message) {
        boolean flag = true;
        String pk = message.getUriPackageName();
        if (!TextUtils.isEmpty((CharSequence)pk)) {
            flag = MzSystemUtils.isPackageInstalled(this.context(), pk);
        }
        return flag;
    }

    @Override
    protected int scheduleNotificationStatus(MessageV3 message) {
        int flag = 0;
        if (message.getBrightRemindSetting() != null && message.getBrightRemindSetting().getIsBrightRemind() && !MzSystemUtils.isInteractive(this.context())) {
            flag = 4;
        } else if (message.getAdvertisementOption() != null && !TextUtils.isEmpty((CharSequence)message.getAdvertisementOption().getAdInstallPackage())) {
            long adLastCloseTime = PushPreferencesUtils.getAdLastCloseTime(this.context(), message.getAdvertisementOption().getAdPackage());
            DebugLogger.i("AbstractMessageHandler", "ad message last click time is: " + adLastCloseTime);
            if (adLastCloseTime != 0L && adLastCloseTime + 1209600000L > System.currentTimeMillis()) {
                flag = 5;
                UxIPUtils.onAdCannotShowMessage(this.context(), message.getAdvertisementOption().getAdInstallPackage(), message.getDeviceId(), message.getTaskId(), message.getSeqId(), message.getPushTimestamp());
            }
        } else if (message.getTimeDisplaySetting() != null) {
            if (!message.getTimeDisplaySetting().isTimeDisplay()) {
                flag = 0;
            } else if (System.currentTimeMillis() > Long.valueOf(message.getTimeDisplaySetting().getEndShowTime())) {
                flag = 1;
                UxIPUtils.notificationEvent(this.context(), "schedule notification expire", 2200, message.getTaskId(), message.getDeviceId());
            } else if (System.currentTimeMillis() > Long.valueOf(message.getTimeDisplaySetting().getStartShowTime())) {
                flag = 2;
                UxIPUtils.notificationEvent(this.context(), "schedule notification on time", 2201, message.getTaskId(), message.getDeviceId());
            } else {
                flag = 3;
                UxIPUtils.notificationEvent(this.context(), "schedule notification delay", 2202, message.getTaskId(), message.getDeviceId());
            }
        }
        return flag;
    }

    @Override
    protected void scheduleShowNotification(MessageV3 message) {
        AlarmManager alarmManager = (AlarmManager)this.context().getSystemService("alarm");
        Intent intent = new Intent(this.context(), NotificationService.class);
        intent.setPackage(message.getPackageName());
        intent.addCategory(message.getPackageName());
        intent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        intent.putExtra("command_type", "reflect_receiver");
        intent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        intent.putExtra("extra_app_push_schedule_notification_message", (Parcelable)message);
        intent.putExtra("method", "schedule_notification");
        int pendingFlag = 0x40000000;
        if (MinSdkChecker.isSupportSetDrawableSmallIcon()) {
            pendingFlag = 0x4000000;
        }
        PendingIntent alarmIntent = PendingIntent.getService((Context)this.context(), (int)0, (Intent)intent, (int)pendingFlag);
        String time = message.getTimeDisplaySetting().getStartShowTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String showTime = null;
        if (!TextUtils.isEmpty((CharSequence)time)) {
            Date showDate = new Date(Long.valueOf(time));
            showTime = sdf.format(showDate);
        }
        long afterTime = Long.valueOf(time) - System.currentTimeMillis();
        DebugLogger.i("AbstractMessageHandler", "after " + afterTime / 1000L + " seconds Notification AlarmManager execute At " + showTime);
        if (alarmManager != null && Build.VERSION.SDK_INT >= 19) {
            DebugLogger.i("AbstractMessageHandler", "setAlarmManager setExact ELAPSED_REALTIME_WAKEUP");
            alarmManager.setExact(2, SystemClock.elapsedRealtime() + afterTime, alarmIntent);
        } else if (alarmManager != null) {
            DebugLogger.i("AbstractMessageHandler", "setAlarmManager set ELAPSED_REALTIME_WAKEUP");
            alarmManager.set(2, SystemClock.elapsedRealtime() + afterTime, alarmIntent);
        }
    }

    @Override
    protected void brightShowNotification(MessageV3 message) {
        Intent intent = new Intent(this.context(), NotificationService.class);
        intent.setPackage(message.getPackageName());
        intent.addCategory(message.getPackageName());
        intent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        intent.putExtra("command_type", "reflect_receiver");
        intent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        intent.putExtra("extra_app_push_bright_notification_message", (Parcelable)message);
        intent.putExtra("method", "bright_notification_message");
        BrightNotification brightNotification = PushMessageProxy.with(this.context()).getBrightNotification();
        if (brightNotification != null) {
            brightNotification.addBrightNotificationIntent(intent, message.getUploadDataPackageName());
        }
    }

    @Override
    public boolean messageMatch(Intent intent) {
        String cloudPushMessage;
        DebugLogger.i("AbstractMessageHandler", "start MessageV3Handler match");
        if (!this.canReceiveMessage(0, this.getPushServiceDefaultPackageName(intent))) {
            return false;
        }
        if ("com.meizu.flyme.push.intent.MESSAGE".equals(intent.getAction()) && "notification_show_v3".equals(this.getIntentMethod(intent))) {
            return true;
        }
        if (TextUtils.isEmpty((CharSequence)this.getIntentMethod(intent)) && !TextUtils.isEmpty((CharSequence)(cloudPushMessage = intent.getStringExtra("message"))) && this.isNotificationJson(cloudPushMessage)) {
            DebugLogger.e("AbstractMessageHandler", "old cloud notification message");
            return true;
        }
        return false;
    }

    @Override
    public int getProcessorType() {
        return 4;
    }

    @Override
    protected void onBeforeEvent(MessageV3 message) {
        UxIPUtils.onReceivePushMessageEvent(this.context(), message.getUploadDataPackageName(), message.getDeviceId(), message.getTaskId(), message.getSeqId(), message.getPushTimestamp(), message.getDelayedReportMillis());
    }

    @Override
    protected void onAfterEvent(MessageV3 message) {
        UxIPUtils.onShowPushMessageEvent(this.context(), message.getUploadDataPackageName(), message.getDeviceId(), message.getTaskId(), message.getSeqId(), message.getPushTimestamp(), message.getDelayedReportMillis());
    }

    private String getQuickPackageName(MessageV3 messageV3) {
        String packageName = null;
        MzPushMessage mzPushMessage = MzPushMessage.fromMessageV3(messageV3);
        String selfDefineContent = mzPushMessage.getSelfDefineContentString();
        if (!TextUtils.isEmpty((CharSequence)selfDefineContent)) {
            try {
                JSONObject quickJson = new JSONObject(selfDefineContent);
                packageName = quickJson.getString("package_name");
            }
            catch (JSONException e) {
                DebugLogger.e("AbstractMessageHandler", "no quick json message");
            }
        }
        return packageName;
    }
}

