/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl.fileupload;

import android.os.Environment;
import com.meizu.cloud.pushinternal.DebugLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipTask {
    private static final String TAG = "ZipTask";
    private static final int BUFF_SIZE = 0x100000;
    private static final int M_SIZE = 1024;
    private final File zipFile;

    public ZipTask(String zipFilepath) {
        this.zipFile = new File(zipFilepath);
    }

    public boolean zip(String ... resFile) {
        boolean isZipSuccess = true;
        try {
            if (!this.zipFile.exists()) {
                this.zipFile.getParentFile().mkdirs();
            }
            ArrayList<File> resFileList = new ArrayList<File>();
            String root = Environment.getExternalStorageDirectory().getAbsolutePath();
            for (String filePath : resFile) {
                File file = new File(root + filePath);
                if (!file.exists()) continue;
                resFileList.add(file);
            }
            this.zipFiles(resFileList, this.zipFile);
        }
        catch (Exception e) {
            isZipSuccess = false;
            e.printStackTrace();
            DebugLogger.e(TAG, "zip file error " + e.getMessage());
        }
        return isZipSuccess;
    }

    public void zip(List<String> fileList) throws Exception {
        if (!this.zipFile.exists()) {
            this.zipFile.getParentFile().mkdirs();
        }
        ArrayList<File> resFileList = new ArrayList<File>();
        String root = Environment.getExternalStorageDirectory().getAbsolutePath();
        for (String filePath : fileList) {
            File file = new File(root + filePath);
            if (!file.exists()) continue;
            resFileList.add(file);
        }
        this.zipFiles(resFileList, this.zipFile);
    }

    private void zipFiles(Collection<File> resFileList, File zipFile) throws Exception {
        ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), 0x100000));
        for (File resFile : resFileList) {
            this.zipFile(resFile, zipOut, "");
        }
        zipOut.close();
    }

    private void zipFiles(Collection<File> resFileList, File zipFile, String comment) throws Exception {
        ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), 0x100000));
        for (File resFile : resFileList) {
            this.zipFile(resFile, zipOut, "");
        }
        zipOut.setComment(comment);
        zipOut.close();
    }

    private void zipFile(File resFile, ZipOutputStream zipOut, String rootPath) throws Exception {
        rootPath = rootPath + (rootPath.trim().length() == 0 ? "" : File.separator) + resFile.getName();
        if (resFile.isDirectory()) {
            File[] fileList = resFile.listFiles();
            int length = fileList.length;
            for (File file : fileList) {
                this.zipFile(file, zipOut, rootPath);
            }
        } else {
            DebugLogger.i(TAG, "current file " + rootPath + "/" + resFile.getName() + " size is " + resFile.length() / 1024L + "KB");
            if (resFile.length() < 0xA00000L) {
                int realLength;
                byte[] buffer = new byte[0x100000];
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(resFile), 0x100000);
                zipOut.putNextEntry(new ZipEntry(rootPath));
                while ((realLength = in.read(buffer)) != -1) {
                    zipOut.write(buffer, 0, realLength);
                }
                in.close();
                zipOut.flush();
                zipOut.closeEntry();
            }
        }
    }
}

