/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl.model;

import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.handler.MzPushMessage;
import org.json.JSONException;
import org.json.JSONObject;

public class SecurityMessage {
    private static final String TAG = "SecurityMessage";
    private static final String SECURITY_ENCRYPTION = "se";
    private static final String TIME_TAMP = "tt";
    private static final String TASK_ID = "ti";
    private static final String TITLE = "tl";
    private static final String CONTENT = "cont";
    private static final String CLICK_TYPE = "ct";
    private static final String PARAMS = "pm";
    private static final int INVALID = -1;
    private int timestamp;
    private String taskId = String.valueOf(-1);
    private String title = "";
    private String content = "";
    private int clickType = -1;
    private String params = "";

    public static boolean check(String decryptSign, MessageV3 messageV3) {
        block13: {
            block12: {
                SecurityMessage securityMessage = SecurityMessage.parseSecurityMessage(decryptSign);
                DebugLogger.e(TAG, "securityMessage " + securityMessage);
                if (System.currentTimeMillis() / 1000L > (long)securityMessage.getTimestamp()) {
                    DebugLogger.e(TAG, "message expire");
                    return false;
                }
                if (!messageV3.getTitle().contains(securityMessage.getTitle())) {
                    DebugLogger.e(TAG, "invalid title");
                    return false;
                }
                if (!messageV3.getContent().contains(securityMessage.getContent())) {
                    DebugLogger.e(TAG, "invalid content");
                    return false;
                }
                if (!String.valueOf(-1).equals(securityMessage.getTaskId()) && !securityMessage.getTaskId().equals(messageV3.getTaskId())) {
                    DebugLogger.e(TAG, "invalid taskId");
                    return false;
                }
                if (securityMessage.getClickType() == -1) break block12;
                switch (securityMessage.getClickType()) {
                    case 1: {
                        if (!messageV3.getActivity().contains(securityMessage.getParams())) {
                            DebugLogger.e(TAG, "invalid click activity");
                            return false;
                        }
                        break block13;
                    }
                    case 2: {
                        if (!messageV3.getWebUrl().contains(securityMessage.getParams())) {
                            DebugLogger.e(TAG, "invalid web url");
                            return false;
                        }
                        break block13;
                    }
                    case 3: {
                        MzPushMessage mzPushMessage = MzPushMessage.fromMessageV3(messageV3);
                        if (!mzPushMessage.getSelfDefineContentString().contains(securityMessage.getParams())) {
                            DebugLogger.e(TAG, "invalid self define");
                            return false;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            DebugLogger.e(TAG, "invalid click type");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSecurityEncryption(MessageV3 messageV3) {
        String encryptionStr = null;
        String notificationMessage = messageV3.getNotificationMessage();
        if (!TextUtils.isEmpty((CharSequence)notificationMessage)) {
            try {
                JSONObject extraObj;
                JSONObject pushDataObj = new JSONObject(notificationMessage);
                JSONObject pushMessageObj = pushDataObj.getJSONObject("data");
                if (!pushMessageObj.isNull("extra") && !(extraObj = pushMessageObj.getJSONObject("extra")).isNull(SECURITY_ENCRYPTION)) {
                    encryptionStr = extraObj.getString(SECURITY_ENCRYPTION);
                }
            }
            catch (JSONException e) {
                DebugLogger.e(TAG, "parse notification message error " + e.getMessage());
            }
            finally {
                if (TextUtils.isEmpty((CharSequence)encryptionStr)) {
                    try {
                        JSONObject extraJson = new JSONObject(notificationMessage);
                        encryptionStr = extraJson.getString(SECURITY_ENCRYPTION);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        DebugLogger.i(TAG, "encrypt message " + encryptionStr);
        return encryptionStr;
    }

    private static SecurityMessage parseSecurityMessage(String decryptSign) {
        SecurityMessage securityMessage = new SecurityMessage();
        try {
            JSONObject jsonObject = new JSONObject(decryptSign);
            if (!jsonObject.isNull(TIME_TAMP)) {
                securityMessage.setTimestamp(jsonObject.getInt(TIME_TAMP));
            }
            if (!jsonObject.isNull(TASK_ID)) {
                securityMessage.setTaskId(jsonObject.getString(TASK_ID));
            }
            if (!jsonObject.isNull(TITLE)) {
                securityMessage.setTitle(jsonObject.getString(TITLE));
            }
            if (!jsonObject.isNull(CONTENT)) {
                securityMessage.setContent(jsonObject.getString(CONTENT));
            }
            if (!jsonObject.isNull(CLICK_TYPE)) {
                securityMessage.setClickType(jsonObject.getInt(CLICK_TYPE));
            }
            if (!jsonObject.isNull(PARAMS)) {
                securityMessage.setParams(jsonObject.getString(PARAMS));
            }
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "parse decryptSign error " + e.getMessage());
        }
        return securityMessage;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getClickType() {
        return this.clickType;
    }

    public void setClickType(int clickType) {
        this.clickType = clickType;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String toString() {
        return "SecurityMessage{timestamp=" + this.timestamp + ", taskId='" + this.taskId + '\'' + ", title='" + this.title + '\'' + ", content='" + this.content + '\'' + ", clickType=" + this.clickType + ", params='" + this.params + '\'' + '}';
    }

    public static class PublicKeyStatus {
        public String code;
        public String message;
        String publicKey;

        public PublicKeyStatus(String message) {
            if (!TextUtils.isEmpty((CharSequence)message)) {
                try {
                    JSONObject jsonObject = new JSONObject(message);
                    if (!jsonObject.isNull("code")) {
                        this.setCode(jsonObject.getString("code"));
                    }
                    if (!jsonObject.isNull("message")) {
                        this.setMessage(jsonObject.getString("message"));
                    }
                    if (!jsonObject.isNull("value")) {
                        this.setPublicKey(jsonObject.getString("value"));
                    }
                }
                catch (JSONException e) {
                    DebugLogger.e(SecurityMessage.TAG, "covert json error " + e.getMessage());
                }
            }
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public String toString() {
            return "PublicKeyStatus{code='" + this.code + '\'' + ", message='" + this.message + '\'' + ", publicKey='" + this.publicKey + '\'' + '}';
        }
    }
}

