/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl.notification;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.MessageSerialize;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.handler.MzPushMessage;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.notification.PushNotification;

public class NotificationArrivedHandler
extends AbstractMessageHandler<MessageV3> {
    public NotificationArrivedHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i("AbstractMessageHandler", "start NotificationArrivedHandler match");
        return "com.meizu.flyme.push.intent.MESSAGE".equals(intent.getAction()) && "notification_arrived".equals(this.getIntentMethod(intent));
    }

    @Override
    public int getProcessorType() {
        return 131072;
    }

    @Override
    protected MessageV3 getMessage(Intent intent) {
        String messageValue = intent.getStringExtra("messageValue");
        if (!TextUtils.isEmpty((CharSequence)messageValue)) {
            return MessageSerialize.stringToMessageV3(messageValue);
        }
        return (MessageV3)intent.getParcelableExtra("pushMessage");
    }

    @Override
    protected void unsafeSend(MessageV3 message, PushNotification pushNotification) {
        if (this.appLogicListener() != null && message != null) {
            this.appLogicListener().onNotificationArrived(this.context(), MzPushMessage.fromMessageV3(message));
        }
    }
}

