/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl.notification;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.MessageSerialize;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.handler.MzPushMessage;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.model.PlatformMessage;
import com.meizu.cloud.pushsdk.notification.MPushMessage;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import com.meizu.cloud.pushsdk.util.UxIPUtils;
import java.util.Map;

public class NotificationClickMessageHandler
extends AbstractMessageHandler<MessageV3> {
    private Context mContext;

    public NotificationClickMessageHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
        this.mContext = context;
    }

    @Override
    protected MessageV3 getMessage(Intent intent) {
        DebugLogger.e("AbstractMessageHandler", "parse message V3");
        String messageValue = intent.getStringExtra("messageValue");
        if (!TextUtils.isEmpty((CharSequence)messageValue)) {
            return this.getMessageNew(messageValue);
        }
        return this.getMessageOld(intent);
    }

    private MessageV3 getMessageNew(String messageValue) {
        MessageV3 messageV3 = MessageSerialize.stringToMessageV3(messageValue);
        return messageV3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageV3 getMessageOld(Intent intent) {
        MessageV3 messageV3 = null;
        try {
            messageV3 = (MessageV3)intent.getParcelableExtra("pushMessage");
        }
        catch (Exception e) {
            DebugLogger.e("AbstractMessageHandler", "cannot get messageV3");
        }
        finally {
            if (messageV3 == null) {
                DebugLogger.e("AbstractMessageHandler", "parse MessageV2 to MessageV3");
                MPushMessage mPushMessage = (MPushMessage)intent.getSerializableExtra("pushMessage");
                messageV3 = MessageV3.parse(this.getPushServiceDefaultPackageName(intent), this.getDeviceId(intent), mPushMessage.getTaskId(), mPushMessage);
            }
        }
        return messageV3;
    }

    @Override
    protected boolean securityCheck(MessageV3 message, String messageMethod) {
        return this.securityCheckMessage(message, messageMethod);
    }

    @Override
    protected void unsafeSend(MessageV3 message, PushNotification pushNotification) {
        if (message == null) {
            return;
        }
        this.clickAction(message);
        if (!TextUtils.isEmpty((CharSequence)message.getTitle()) && !TextUtils.isEmpty((CharSequence)message.getContent()) && this.appLogicListener() != null) {
            this.appLogicListener().onNotificationClicked(this.context(), MzPushMessage.fromMessageV3(message));
        }
        this.clearNotification(message);
        this.cleanAdNotificationInfo(this.mContext, message);
    }

    private void clickAction(MessageV3 message) {
        PushPreferencesUtils.putDiscardNotificationIdByPackageName(this.context(), message.getPackageName(), 0);
        Intent privateIntent = this.buildIntent(this.context(), message);
        if (privateIntent != null) {
            privateIntent.addFlags(0x10000000);
            try {
                this.context().startActivity(privateIntent);
            }
            catch (Exception e) {
                DebugLogger.e("AbstractMessageHandler", "Click message StartActivity error " + e.getMessage());
            }
        }
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i("AbstractMessageHandler", "start NotificationClickMessageHandler match");
        return "com.meizu.flyme.push.intent.MESSAGE".equals(intent.getAction()) && "private".equals(this.getIntentMethod(intent));
    }

    @Override
    public int getProcessorType() {
        return 64;
    }

    @Override
    protected void onBeforeEvent(MessageV3 message) {
        UxIPUtils.onClickPushMessageEvent(this.context(), message.getUploadDataPackageName(), TextUtils.isEmpty((CharSequence)message.getDeviceId()) ? this.getDeviceId(null) : message.getDeviceId(), message.getTaskId(), message.getSeqId(), message.getPushTimestamp());
    }

    private Intent buildIntent(Context context, MessageV3 messageV3) {
        Intent intent = null;
        String openClassName = messageV3.getUriPackageName();
        if (TextUtils.isEmpty((CharSequence)openClassName)) {
            openClassName = messageV3.getUploadDataPackageName();
        }
        DebugLogger.i("AbstractMessageHandler", "openClassName is " + openClassName);
        if (0 == messageV3.getClickType()) {
            intent = context.getPackageManager().getLaunchIntentForPackage(openClassName);
            if (intent != null && messageV3.getParamsMap() != null) {
                Map<String, String> paramsMap = messageV3.getParamsMap();
                for (Map.Entry<String, String> paramsEntry : paramsMap.entrySet()) {
                    DebugLogger.i("AbstractMessageHandler", " launcher activity key " + paramsEntry.getKey() + " value " + paramsEntry.getValue());
                    if (TextUtils.isEmpty((CharSequence)paramsEntry.getKey()) || TextUtils.isEmpty((CharSequence)paramsEntry.getValue())) continue;
                    String value = paramsEntry.getValue();
                    intent.putExtra(paramsEntry.getKey(), value);
                }
            }
        } else if (1 == messageV3.getClickType()) {
            intent = new Intent();
            if (messageV3.getParamsMap() != null) {
                Map<String, String> paramsMap = messageV3.getParamsMap();
                for (Map.Entry<String, String> paramsEntry : paramsMap.entrySet()) {
                    DebugLogger.i("AbstractMessageHandler", " key " + paramsEntry.getKey() + " value " + paramsEntry.getValue());
                    if (TextUtils.isEmpty((CharSequence)paramsEntry.getKey()) || TextUtils.isEmpty((CharSequence)paramsEntry.getValue())) continue;
                    String value = paramsEntry.getValue();
                    intent.putExtra(paramsEntry.getKey(), value);
                }
            }
            intent.setClassName(openClassName, messageV3.getActivity());
            DebugLogger.i("AbstractMessageHandler", intent.toUri(1));
        } else if (2 == messageV3.getClickType()) {
            Uri uri = Uri.parse((String)messageV3.getWebUrl());
            intent = new Intent("android.intent.action.VIEW", uri);
            String uriPackageName = messageV3.getUriPackageName();
            if (!TextUtils.isEmpty((CharSequence)uriPackageName)) {
                intent.setPackage(uriPackageName);
                DebugLogger.i("AbstractMessageHandler", "set uri package " + uriPackageName);
            }
        } else if (3 == messageV3.getClickType()) {
            DebugLogger.i("AbstractMessageHandler", "CLICK_TYPE_SELF_DEFINE_ACTION");
        }
        if (intent != null) {
            intent.putExtra("platform_extra", PlatformMessage.builder().taskId(messageV3.getTaskId()).build().toJson());
        }
        return intent;
    }
}

