/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl.notification;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.handler.MzPushMessage;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import com.meizu.cloud.pushsdk.util.UxIPUtils;

public class NotificationCloseMessageHandler
extends AbstractMessageHandler<MessageV3> {
    private Context mContext;

    public NotificationCloseMessageHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
        this.mContext = context;
    }

    @Override
    protected MessageV3 getMessage(Intent intent) {
        return (MessageV3)intent.getParcelableExtra("pushMessage");
    }

    @Override
    protected void unsafeSend(MessageV3 message, PushNotification pushNotification) {
        if (message == null) {
            return;
        }
        this.closeAction(message);
        if (!TextUtils.isEmpty((CharSequence)message.getTitle()) && !TextUtils.isEmpty((CharSequence)message.getContent()) && this.appLogicListener() != null) {
            this.appLogicListener().onNotificationDeleted(this.context(), MzPushMessage.fromMessageV3(message));
        }
        this.clearNotification(message);
        this.cleanAdNotificationInfo(this.mContext, message);
    }

    private void closeAction(MessageV3 message) {
        if (message.getAdvertisementOption() == null || TextUtils.isEmpty((CharSequence)message.getAdvertisementOption().getAdPackage())) {
            return;
        }
        PushPreferencesUtils.putAdLastCloseTime(this.mContext, message.getAdvertisementOption().getAdPackage(), System.currentTimeMillis());
        UxIPUtils.onAdClickCloseEvent(this.mContext, message.getAdvertisementOption().getAdInstallPackage(), message.getDeviceId(), message.getTaskId(), message.getSeqId(), message.getPushTimestamp());
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i("AbstractMessageHandler", "start NotificationCloseMessageHandler match");
        return "com.meizu.flyme.push.intent.MESSAGE".equals(intent.getAction()) && "notification_close".equals(this.getIntentMethod(intent));
    }

    @Override
    public int getProcessorType() {
        return 0x100000;
    }

    @Override
    protected void onBeforeEvent(MessageV3 message) {
        UxIPUtils.onDeletePushMessageEvent(this.context(), message.getUploadDataPackageName(), message.getDeviceId(), message.getTaskId(), message.getSeqId(), message.getPushTimestamp());
    }
}

